/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.junit4;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.Assume;
import org.junit.runner.Description;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;
import org.springframework.test.annotation.Repeat;
import org.springframework.test.annotation.Timed;
import org.springframework.test.context.TestContextManager;
import org.springframework.test.context.junit4.SpringTestMethod;

class SpringMethodRoadie {
    protected static final Log logger = LogFactory.getLog(SpringMethodRoadie.class);
    private final TestContextManager testContextManager;
    private final Object testInstance;
    private final SpringTestMethod testMethod;
    private final RunNotifier notifier;
    private final Description description;
    private Throwable testException;

    public SpringMethodRoadie(TestContextManager testContextManager, Object testInstance, SpringTestMethod testMethod, RunNotifier notifier, Description description) {
        this.testContextManager = testContextManager;
        this.testInstance = testInstance;
        this.testMethod = testMethod;
        this.notifier = notifier;
        this.description = description;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        block12: {
            if (this.testMethod.isIgnored()) {
                this.notifier.fireTestIgnored(this.description);
                return;
            }
            this.notifier.fireTestStarted(this.description);
            try {
                Timed timedAnnotation = this.testMethod.getMethod().getAnnotation(Timed.class);
                long springTimeout = timedAnnotation != null && timedAnnotation.millis() > 0L ? timedAnnotation.millis() : 0L;
                long junitTimeout = this.testMethod.getTimeout();
                if (springTimeout > 0L && junitTimeout > 0L) {
                    throw new IllegalStateException("Test method [" + this.testMethod.getMethod() + "] has been configured with Spring's @Timed(millis=" + springTimeout + ") and JUnit's @Test(timeout=" + junitTimeout + ") annotations. Only one declaration of a 'timeout' is permitted per test method.");
                }
                if (springTimeout > 0L) {
                    long startTime = System.currentTimeMillis();
                    try {
                        this.runTest();
                        break block12;
                    }
                    finally {
                        long elapsed = System.currentTimeMillis() - startTime;
                        if (elapsed > springTimeout) {
                            this.addFailure(new Exception("Took " + elapsed + " ms; limit was " + springTimeout));
                        }
                    }
                }
                if (junitTimeout > 0L) {
                    this.runWithTimeout(junitTimeout);
                } else {
                    this.runTest();
                }
            }
            finally {
                this.notifier.fireTestFinished(this.description);
            }
        }
    }

    protected void runWithTimeout(final long timeout) {
        this.runWithRepetitions(new Runnable(){

            public void run() {
                ExecutorService service = Executors.newSingleThreadExecutor();
                Runnable runnable = new Runnable(){

                    public void run() {
                        SpringMethodRoadie.this.runTestMethod();
                    }
                };
                Future<?> result = service.submit(runnable);
                service.shutdown();
                try {
                    boolean terminated = service.awaitTermination(timeout, TimeUnit.MILLISECONDS);
                    if (!terminated) {
                        service.shutdownNow();
                    }
                    result.get(0L, TimeUnit.MILLISECONDS);
                }
                catch (TimeoutException ex) {
                    SpringMethodRoadie.this.addFailure(new Exception(String.format("Test timed out after %d milliseconds", timeout)));
                }
                catch (Exception ex) {
                    SpringMethodRoadie.this.addFailure(ex);
                }
            }
        });
    }

    protected void runTest() {
        this.runWithRepetitions(new Runnable(){

            public void run() {
                SpringMethodRoadie.this.runTestMethod();
            }
        });
    }

    protected void runWithRepetitions(Runnable test) {
        Method method = this.testMethod.getMethod();
        Repeat repeat = method.getAnnotation(Repeat.class);
        int runs = repeat != null && repeat.value() > 1 ? repeat.value() : 1;
        for (int i = 0; i < runs; ++i) {
            if (runs > 1 && logger.isInfoEnabled()) {
                logger.info((Object)("Repetition " + (i + 1) + " of test " + method.getName()));
            }
            this.runBeforesThenTestThenAfters(test);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runBeforesThenTestThenAfters(Runnable test) {
        try {
            this.runBefores();
            test.run();
        }
        catch (FailedBefore failedBefore) {
        }
        finally {
            this.runAfters();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runTestMethod() {
        this.testException = null;
        try {
            this.testMethod.invoke(this.testInstance);
            if (this.testMethod.expectsException()) {
                this.addFailure((Throwable)((Object)new AssertionError((Object)("Expected exception: " + this.testMethod.getExpectedException().getName()))));
            }
        }
        catch (InvocationTargetException ex) {
            this.testException = ex.getTargetException();
            if (this.testException instanceof Assume.AssumptionViolatedException) {
                return;
            }
            if (!this.testMethod.expectsException()) {
                this.addFailure(this.testException);
            } else if (this.testMethod.isUnexpected(this.testException)) {
                this.addFailure(new Exception("Unexpected exception, expected <" + this.testMethod.getExpectedException().getName() + "> but was <" + this.testException.getClass().getName() + ">", this.testException));
            }
        }
        catch (Throwable ex) {
            this.addFailure(ex);
        }
        finally {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Test method [" + this.testMethod.getMethod() + "] threw exception: " + this.testException));
            }
        }
    }

    protected void runBefores() throws FailedBefore {
        try {
            this.testContextManager.beforeTestMethod(this.testInstance, this.testMethod.getMethod());
            List<Method> befores = this.testMethod.getBefores();
            for (Method before : befores) {
                before.invoke(this.testInstance, new Object[0]);
            }
        }
        catch (InvocationTargetException ex) {
            this.addFailure(ex.getTargetException());
            throw new FailedBefore();
        }
        catch (Throwable ex) {
            this.addFailure(ex);
            throw new FailedBefore();
        }
    }

    protected void runAfters() {
        List<Method> afters = this.testMethod.getAfters();
        for (Method after : afters) {
            try {
                after.invoke(this.testInstance, new Object[0]);
            }
            catch (InvocationTargetException ex) {
                this.addFailure(ex.getTargetException());
            }
            catch (Throwable ex) {
                this.addFailure(ex);
            }
        }
        try {
            this.testContextManager.afterTestMethod(this.testInstance, this.testMethod.getMethod(), this.testException);
        }
        catch (Throwable ex) {
            this.addFailure(ex);
        }
    }

    protected void addFailure(Throwable exception) {
        this.notifier.fireTestFailure(new Failure(this.description, exception));
    }

    private static class FailedBefore
    extends Exception {
        private FailedBefore() {
        }
    }
}

