/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.servlet.result;

import java.lang.reflect.Method;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.springframework.test.util.AssertionErrors;
import org.springframework.test.util.MatcherAssertionErrors;
import org.springframework.test.web.servlet.MvcResult;
import org.springframework.test.web.servlet.ResultMatcher;
import org.springframework.util.ClassUtils;
import org.springframework.web.method.HandlerMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HandlerResultMatchers {
    protected HandlerResultMatchers() {
    }

    public ResultMatcher handlerType(final Class<?> type) {
        return new ResultMatcher(){

            public void match(MvcResult result) throws Exception {
                Object handler = result.getHandler();
                AssertionErrors.assertTrue("No handler: ", handler != null);
                Class actual = handler.getClass();
                if (HandlerMethod.class.isInstance(handler)) {
                    actual = ((HandlerMethod)handler).getBeanType();
                }
                AssertionErrors.assertEquals("Handler type", type, ClassUtils.getUserClass((Class)actual));
            }
        };
    }

    public ResultMatcher methodName(final Matcher<? super String> matcher) {
        return new ResultMatcher(){

            public void match(MvcResult result) throws Exception {
                Object handler = result.getHandler();
                AssertionErrors.assertTrue("No handler: ", handler != null);
                AssertionErrors.assertTrue("Not a HandlerMethod: " + handler, HandlerMethod.class.isInstance(handler));
                MatcherAssertionErrors.assertThat("HandlerMethod", ((HandlerMethod)handler).getMethod().getName(), matcher);
            }
        };
    }

    public ResultMatcher methodName(String name) {
        return this.methodName((Matcher<? super String>)Matchers.equalTo((Object)name));
    }

    public ResultMatcher method(final Method method) {
        return new ResultMatcher(){

            public void match(MvcResult result) throws Exception {
                Object handler = result.getHandler();
                AssertionErrors.assertTrue("No handler: ", handler != null);
                AssertionErrors.assertTrue("Not a HandlerMethod: " + handler, HandlerMethod.class.isInstance(handler));
                AssertionErrors.assertEquals("HandlerMethod", method, ((HandlerMethod)handler).getMethod());
            }
        };
    }
}

