/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.servlet.result;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.springframework.test.util.AssertionErrors;
import org.springframework.test.util.MatcherAssertionErrors;
import org.springframework.test.web.servlet.MvcResult;
import org.springframework.test.web.servlet.ResultMatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HeaderResultMatchers {
    protected HeaderResultMatchers() {
    }

    public ResultMatcher string(final String name, final Matcher<? super String> matcher) {
        return new ResultMatcher(){

            public void match(MvcResult result) {
                MatcherAssertionErrors.assertThat("Response header", result.getResponse().getHeader(name), matcher);
            }
        };
    }

    public ResultMatcher string(String name, String value) {
        return this.string(name, (Matcher<? super String>)Matchers.equalTo((Object)value));
    }

    public ResultMatcher longValue(final String name, final long value) {
        return new ResultMatcher(){

            public void match(MvcResult result) {
                AssertionErrors.assertEquals("Response header " + name, value, Long.parseLong(result.getResponse().getHeader(name)));
            }
        };
    }
}

