/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.servlet.result;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.springframework.test.util.AssertionErrors;
import org.springframework.test.util.MatcherAssertionErrors;
import org.springframework.test.web.servlet.MvcResult;
import org.springframework.test.web.servlet.ResultMatcher;
import org.springframework.ui.ModelMap;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.servlet.ModelAndView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelResultMatchers {
    protected ModelResultMatchers() {
    }

    public <T> ResultMatcher attribute(final String name, final Matcher<T> matcher) {
        return new ResultMatcher(){

            public void match(MvcResult result) throws Exception {
                ModelAndView mav = ModelResultMatchers.this.getModelAndView(result);
                MatcherAssertionErrors.assertThat("Model attribute '" + name + "'", mav.getModel().get(name), matcher);
            }
        };
    }

    public ResultMatcher attribute(String name, Object value) {
        return this.attribute(name, Matchers.equalTo((Object)value));
    }

    public ResultMatcher attributeExists(final String ... names) {
        return new ResultMatcher(){

            public void match(MvcResult result) throws Exception {
                AssertionErrors.assertTrue("No ModelAndView found", result.getModelAndView() != null);
                for (String name : names) {
                    ModelResultMatchers.this.attribute(name, Matchers.notNullValue()).match(result);
                }
            }
        };
    }

    public ResultMatcher attributeErrorCount(final String name, final int expectedCount) {
        return new ResultMatcher(){

            public void match(MvcResult result) throws Exception {
                ModelAndView mav = ModelResultMatchers.this.getModelAndView(result);
                BindingResult errors = ModelResultMatchers.this.getBindingResult(mav, name);
                AssertionErrors.assertEquals("Binding/validation error count for attribute [" + name + "], ", expectedCount, errors.getErrorCount());
            }
        };
    }

    public ResultMatcher attributeHasErrors(final String ... names) {
        return new ResultMatcher(){

            public void match(MvcResult mvcResult) throws Exception {
                ModelAndView mav = ModelResultMatchers.this.getModelAndView(mvcResult);
                for (String name : names) {
                    BindingResult result = ModelResultMatchers.this.getBindingResult(mav, name);
                    AssertionErrors.assertTrue("No errors for attribute [" + name + "]", result.hasErrors());
                }
            }
        };
    }

    public ResultMatcher attributeHasNoErrors(final String ... names) {
        return new ResultMatcher(){

            public void match(MvcResult mvcResult) throws Exception {
                ModelAndView mav = ModelResultMatchers.this.getModelAndView(mvcResult);
                for (String name : names) {
                    BindingResult result = ModelResultMatchers.this.getBindingResult(mav, name);
                    AssertionErrors.assertTrue("No errors for attribute [" + name + "]", !result.hasErrors());
                }
            }
        };
    }

    public ResultMatcher attributeHasFieldErrors(final String name, final String ... fieldNames) {
        return new ResultMatcher(){

            public void match(MvcResult mvcResult) throws Exception {
                ModelAndView mav = ModelResultMatchers.this.getModelAndView(mvcResult);
                BindingResult result = ModelResultMatchers.this.getBindingResult(mav, name);
                AssertionErrors.assertTrue("No errors for attribute: [" + name + "]", result.hasErrors());
                for (String fieldName : fieldNames) {
                    AssertionErrors.assertTrue("No errors for field: [" + fieldName + "] of attribute [" + name + "]", result.hasFieldErrors(fieldName));
                }
            }
        };
    }

    public <T> ResultMatcher errorCount(final int expectedCount) {
        return new ResultMatcher(){

            public void match(MvcResult result) throws Exception {
                int actualCount = ModelResultMatchers.this.getErrorCount(ModelResultMatchers.this.getModelAndView(result).getModelMap());
                AssertionErrors.assertEquals("Binding/validation error count", expectedCount, actualCount);
            }
        };
    }

    public <T> ResultMatcher hasErrors() {
        return new ResultMatcher(){

            public void match(MvcResult result) throws Exception {
                int count = ModelResultMatchers.this.getErrorCount(ModelResultMatchers.this.getModelAndView(result).getModelMap());
                AssertionErrors.assertTrue("Expected binding/validation errors", count != 0);
            }
        };
    }

    public <T> ResultMatcher hasNoErrors() {
        return new ResultMatcher(){

            public void match(MvcResult result) throws Exception {
                ModelAndView mav = ModelResultMatchers.this.getModelAndView(result);
                for (Object value : mav.getModel().values()) {
                    if (!(value instanceof Errors)) continue;
                    AssertionErrors.assertTrue("Unexpected binding/validation error(s) [" + value + "]", !((Errors)value).hasErrors());
                }
            }
        };
    }

    public <T> ResultMatcher size(final int size) {
        return new ResultMatcher(){

            public void match(MvcResult result) throws Exception {
                ModelAndView mav = ModelResultMatchers.this.getModelAndView(result);
                int actual = 0;
                for (String key : mav.getModel().keySet()) {
                    if (key.startsWith(BindingResult.MODEL_KEY_PREFIX)) continue;
                    ++actual;
                }
                AssertionErrors.assertEquals("Model size", size, actual);
            }
        };
    }

    private ModelAndView getModelAndView(MvcResult mvcResult) {
        ModelAndView mav = mvcResult.getModelAndView();
        AssertionErrors.assertTrue("No ModelAndView found", mav != null);
        return mav;
    }

    private BindingResult getBindingResult(ModelAndView mav, String name) {
        BindingResult result = (BindingResult)mav.getModel().get(BindingResult.MODEL_KEY_PREFIX + name);
        AssertionErrors.assertTrue("No BindingResult for attribute: " + name, result != null);
        return result;
    }

    private int getErrorCount(ModelMap model) {
        int count = 0;
        for (Object value : model.values()) {
            if (!(value instanceof Errors)) continue;
            count += ((Errors)value).getErrorCount();
        }
        return count;
    }
}

