/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.servlet.result;

import java.util.Map;
import javax.xml.xpath.XPathExpressionException;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.springframework.test.util.XpathExpectationsHelper;
import org.springframework.test.web.servlet.MvcResult;
import org.springframework.test.web.servlet.ResultMatcher;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XpathResultMatchers {
    private final XpathExpectationsHelper xpathHelper;

    protected XpathResultMatchers(String expression, Map<String, String> namespaces, Object ... args) throws XPathExpressionException {
        this.xpathHelper = new XpathExpectationsHelper(expression, namespaces, args);
    }

    public ResultMatcher node(final Matcher<? super Node> matcher) {
        return new ResultMatcher(){

            public void match(MvcResult result) throws Exception {
                String content = result.getResponse().getContentAsString();
                XpathResultMatchers.this.xpathHelper.assertNode(content, (Matcher<? super Node>)matcher);
            }
        };
    }

    public ResultMatcher exists() {
        return this.node((Matcher<? super Node>)Matchers.notNullValue());
    }

    public ResultMatcher doesNotExist() {
        return this.node((Matcher<? super Node>)Matchers.nullValue());
    }

    public ResultMatcher nodeCount(final Matcher<Integer> matcher) {
        return new ResultMatcher(){

            public void match(MvcResult result) throws Exception {
                String content = result.getResponse().getContentAsString();
                XpathResultMatchers.this.xpathHelper.assertNodeCount(content, (Matcher<Integer>)matcher);
            }
        };
    }

    public ResultMatcher nodeCount(int count) {
        return this.nodeCount((Matcher<Integer>)Matchers.equalTo((Object)count));
    }

    public ResultMatcher string(final Matcher<? super String> matcher) {
        return new ResultMatcher(){

            public void match(MvcResult result) throws Exception {
                String content = result.getResponse().getContentAsString();
                XpathResultMatchers.this.xpathHelper.assertString(content, (Matcher<? super String>)matcher);
            }
        };
    }

    public ResultMatcher string(String value) {
        return this.string((Matcher<? super String>)Matchers.equalTo((Object)value));
    }

    public ResultMatcher number(final Matcher<? super Double> matcher) {
        return new ResultMatcher(){

            public void match(MvcResult result) throws Exception {
                String content = result.getResponse().getContentAsString();
                XpathResultMatchers.this.xpathHelper.assertNumber(content, (Matcher<? super Double>)matcher);
            }
        };
    }

    public ResultMatcher number(Double value) {
        return this.number((Matcher<? super Double>)Matchers.equalTo((Object)value));
    }

    public ResultMatcher booleanValue(final Boolean value) {
        return new ResultMatcher(){

            public void match(MvcResult result) throws Exception {
                String content = result.getResponse().getContentAsString();
                XpathResultMatchers.this.xpathHelper.assertBoolean(content, value);
            }
        };
    }
}

