/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.support;

import java.util.ArrayList;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.GenericTypeResolver;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.core.io.ClassPathResource;
import org.springframework.test.context.ContextConfigurationAttributes;
import org.springframework.test.context.MergedContextConfiguration;
import org.springframework.test.context.SmartContextLoader;
import org.springframework.test.context.util.TestContextResourceUtils;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;

public abstract class AbstractContextLoader
implements SmartContextLoader {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final Log logger = LogFactory.getLog(AbstractContextLoader.class);

    @Override
    public void processContextConfiguration(ContextConfigurationAttributes configAttributes) {
        String[] processedLocations = this.processLocations(configAttributes.getDeclaringClass(), configAttributes.getLocations());
        configAttributes.setLocations(processedLocations);
    }

    protected void prepareContext(ConfigurableApplicationContext context, MergedContextConfiguration mergedConfig) {
        context.getEnvironment().setActiveProfiles(mergedConfig.getActiveProfiles());
        Set<Class<? extends ApplicationContextInitializer<? extends ConfigurableApplicationContext>>> initializerClasses = mergedConfig.getContextInitializerClasses();
        if (initializerClasses.isEmpty()) {
            return;
        }
        ArrayList<ApplicationContextInitializer> initializerInstances = new ArrayList<ApplicationContextInitializer>();
        Class<?> contextClass = context.getClass();
        for (Class<? extends ApplicationContextInitializer<? extends ConfigurableApplicationContext>> initializerClass : initializerClasses) {
            Class initializerContextClass = GenericTypeResolver.resolveTypeArgument(initializerClass, ApplicationContextInitializer.class);
            Assert.isAssignable((Class)initializerContextClass, contextClass, (String)String.format("Could not add context initializer [%s] since its generic parameter [%s] is not assignable from the type of application context used by this context loader [%s]: ", initializerClass.getName(), initializerContextClass.getName(), contextClass.getName()));
            initializerInstances.add((ApplicationContextInitializer)BeanUtils.instantiateClass(initializerClass));
        }
        AnnotationAwareOrderComparator.sort(initializerInstances);
        for (ApplicationContextInitializer initializer : initializerInstances) {
            initializer.initialize(context);
        }
    }

    @Override
    public final String[] processLocations(Class<?> clazz, String ... locations) {
        return ObjectUtils.isEmpty((Object[])locations) && this.isGenerateDefaultLocations() ? this.generateDefaultLocations(clazz) : this.modifyLocations(clazz, locations);
    }

    protected String[] generateDefaultLocations(Class<?> clazz) {
        Assert.notNull(clazz, (String)"Class must not be null");
        String suffix = this.getResourceSuffix();
        Assert.hasText((String)suffix, (String)"Resource suffix must not be empty");
        String resourcePath = ClassUtils.convertClassNameToResourcePath((String)clazz.getName()) + suffix;
        String prefixedResourcePath = "classpath:" + resourcePath;
        ClassPathResource classPathResource = new ClassPathResource(resourcePath);
        if (classPathResource.exists()) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)String.format("Detected default resource location \"%s\" for test class [%s]", prefixedResourcePath, clazz.getName()));
            }
            return new String[]{prefixedResourcePath};
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)String.format("Could not detect default resource locations for test class [%s]: %s does not exist", clazz.getName(), classPathResource));
        }
        return EMPTY_STRING_ARRAY;
    }

    protected String[] modifyLocations(Class<?> clazz, String ... locations) {
        return TestContextResourceUtils.convertToClasspathResourcePaths(clazz, locations);
    }

    protected boolean isGenerateDefaultLocations() {
        return true;
    }

    protected abstract String getResourceSuffix();
}

