/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.support;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanInstantiationException;
import org.springframework.beans.BeanUtils;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.test.context.BootstrapContext;
import org.springframework.test.context.CacheAwareContextLoaderDelegate;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.ContextConfigurationAttributes;
import org.springframework.test.context.ContextHierarchy;
import org.springframework.test.context.ContextLoader;
import org.springframework.test.context.MergedContextConfiguration;
import org.springframework.test.context.SmartContextLoader;
import org.springframework.test.context.TestContextBootstrapper;
import org.springframework.test.context.TestExecutionListener;
import org.springframework.test.context.TestExecutionListeners;
import org.springframework.test.context.support.ActiveProfilesUtils;
import org.springframework.test.context.support.ApplicationContextInitializerUtils;
import org.springframework.test.context.support.ContextLoaderUtils;
import org.springframework.test.util.MetaAnnotationUtils;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public abstract class AbstractTestContextBootstrapper
implements TestContextBootstrapper {
    private final Log logger = LogFactory.getLog(this.getClass());
    private BootstrapContext bootstrapContext;

    @Override
    public void setBootstrapContext(BootstrapContext bootstrapContext) {
        this.bootstrapContext = bootstrapContext;
    }

    @Override
    public BootstrapContext getBootstrapContext() {
        return this.bootstrapContext;
    }

    @Override
    public final List<TestExecutionListener> getTestExecutionListeners() {
        Class<?> clazz = this.getBootstrapContext().getTestClass();
        Class<TestExecutionListeners> annotationType = TestExecutionListeners.class;
        ArrayList<Object> classesList = new ArrayList<Object>();
        MetaAnnotationUtils.AnnotationDescriptor<TestExecutionListeners> descriptor = MetaAnnotationUtils.findAnnotationDescriptor(clazz, annotationType);
        if (descriptor == null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("@TestExecutionListeners is not present for class [" + clazz.getName() + "]: using defaults."));
            }
            classesList.addAll(this.getDefaultTestExecutionListenerClasses());
        } else {
            while (descriptor != null) {
                Class<?> declaringClass = descriptor.getDeclaringClass();
                AnnotationAttributes annAttrs = descriptor.getAnnotationAttributes();
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace((Object)String.format("Retrieved @TestExecutionListeners attributes [%s] for declaring class [%s].", annAttrs, declaringClass.getName()));
                }
                Object[] objectArray = annAttrs.getClassArray("value");
                Object[] listenerClasses = annAttrs.getClassArray("listeners");
                if (!ObjectUtils.isEmpty((Object[])objectArray) && !ObjectUtils.isEmpty((Object[])listenerClasses)) {
                    throw new IllegalStateException(String.format("Class [%s] configured with @TestExecutionListeners' 'value' [%s] and 'listeners' [%s] attributes. Use one or the other, but not both.", declaringClass.getName(), ObjectUtils.nullSafeToString((Object[])objectArray), ObjectUtils.nullSafeToString((Object[])listenerClasses)));
                }
                if (!ObjectUtils.isEmpty((Object[])objectArray)) {
                    listenerClasses = objectArray;
                }
                if (listenerClasses != null) {
                    classesList.addAll(0, Arrays.asList(listenerClasses));
                }
                descriptor = annAttrs.getBoolean("inheritListeners") ? MetaAnnotationUtils.findAnnotationDescriptor(descriptor.getRootDeclaringClass().getSuperclass(), annotationType) : null;
            }
        }
        ArrayList<TestExecutionListener> listeners = new ArrayList<TestExecutionListener>(classesList.size());
        for (Class clazz2 : classesList) {
            NoClassDefFoundError ncdfe;
            block12: {
                ncdfe = null;
                try {
                    listeners.add((TestExecutionListener)BeanUtils.instantiateClass((Class)clazz2));
                }
                catch (NoClassDefFoundError err) {
                    ncdfe = err;
                }
                catch (BeanInstantiationException ex) {
                    if (!(ex.getCause() instanceof NoClassDefFoundError)) break block12;
                    ncdfe = (NoClassDefFoundError)ex.getCause();
                }
            }
            if (ncdfe == null || !this.logger.isInfoEnabled()) continue;
            this.logger.info((Object)String.format("Could not instantiate TestExecutionListener [%s]. Specify custom listener classes or make the default listener classes (and their required dependencies) available. Offending class: [%s]", clazz2.getName(), ncdfe.getMessage()));
        }
        return listeners;
    }

    protected Set<Class<? extends TestExecutionListener>> getDefaultTestExecutionListenerClasses() {
        LinkedHashSet<Class<? extends TestExecutionListener>> defaultListenerClasses = new LinkedHashSet<Class<? extends TestExecutionListener>>();
        ClassLoader cl = this.getClass().getClassLoader();
        for (String className : this.getDefaultTestExecutionListenerClassNames()) {
            try {
                defaultListenerClasses.add(ClassUtils.forName((String)className, (ClassLoader)cl));
            }
            catch (Throwable ex) {
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug((Object)("Could not load default TestExecutionListener class [" + className + "]. Specify custom listener classes or make the default listener classes available."), ex);
            }
        }
        return defaultListenerClasses;
    }

    @Override
    public final MergedContextConfiguration buildMergedContextConfiguration() {
        Class<?> testClass = this.getBootstrapContext().getTestClass();
        CacheAwareContextLoaderDelegate cacheAwareContextLoaderDelegate = this.getBootstrapContext().getCacheAwareContextLoaderDelegate();
        if (MetaAnnotationUtils.findAnnotationDescriptorForTypes(testClass, ContextConfiguration.class, ContextHierarchy.class) == null) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)String.format("Neither @ContextConfiguration nor @ContextHierarchy found for test class [%s]", testClass.getName()));
            }
            return new MergedContextConfiguration(testClass, null, null, null, null);
        }
        if (AnnotationUtils.findAnnotation(testClass, ContextHierarchy.class) != null) {
            Map<String, List<ContextConfigurationAttributes>> hierarchyMap = ContextLoaderUtils.buildContextHierarchyMap(testClass);
            MergedContextConfiguration parentConfig = null;
            MergedContextConfiguration mergedConfig = null;
            for (List<ContextConfigurationAttributes> list : hierarchyMap.values()) {
                ArrayList<ContextConfigurationAttributes> reversedList = new ArrayList<ContextConfigurationAttributes>(list);
                Collections.reverse(reversedList);
                Assert.notEmpty(reversedList, (String)"ContextConfigurationAttributes list must not be empty");
                Class<?> declaringClass = ((ContextConfigurationAttributes)reversedList.get(0)).getDeclaringClass();
                parentConfig = mergedConfig = this.buildMergedContextConfiguration(declaringClass, reversedList, parentConfig, cacheAwareContextLoaderDelegate);
            }
            return mergedConfig;
        }
        return this.buildMergedContextConfiguration(testClass, ContextLoaderUtils.resolveContextConfigurationAttributes(testClass), null, cacheAwareContextLoaderDelegate);
    }

    private MergedContextConfiguration buildMergedContextConfiguration(Class<?> testClass, List<ContextConfigurationAttributes> configAttributesList, MergedContextConfiguration parentConfig, CacheAwareContextLoaderDelegate cacheAwareContextLoaderDelegate) {
        ContextLoader contextLoader = this.resolveContextLoader(testClass, configAttributesList);
        ArrayList<String> locationsList = new ArrayList<String>();
        ArrayList classesList = new ArrayList();
        for (ContextConfigurationAttributes configAttributes : configAttributesList) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)String.format("Processing locations and classes for context configuration attributes %s", configAttributes));
            }
            if (contextLoader instanceof SmartContextLoader) {
                SmartContextLoader smartContextLoader = (SmartContextLoader)contextLoader;
                smartContextLoader.processContextConfiguration(configAttributes);
                locationsList.addAll(0, Arrays.asList(configAttributes.getLocations()));
                classesList.addAll(0, Arrays.asList(configAttributes.getClasses()));
            } else {
                String[] processedLocations = contextLoader.processLocations(configAttributes.getDeclaringClass(), configAttributes.getLocations());
                locationsList.addAll(0, Arrays.asList(processedLocations));
            }
            if (configAttributes.isInheritLocations()) continue;
            break;
        }
        String[] locations = StringUtils.toStringArray(locationsList);
        Class[] classes = ClassUtils.toClassArray(classesList);
        Set<Class<? extends ApplicationContextInitializer<? extends ConfigurableApplicationContext>>> initializerClasses = ApplicationContextInitializerUtils.resolveInitializerClasses(configAttributesList);
        String[] activeProfiles = ActiveProfilesUtils.resolveActiveProfiles(testClass);
        return this.buildMergedContextConfiguration(testClass, locations, classes, initializerClasses, activeProfiles, contextLoader, cacheAwareContextLoaderDelegate, parentConfig);
    }

    private ContextLoader resolveContextLoader(Class<?> testClass, List<ContextConfigurationAttributes> configAttributesList) {
        Assert.notNull(testClass, (String)"Class must not be null");
        Assert.notEmpty(configAttributesList, (String)"ContextConfigurationAttributes list must not be empty");
        Class<? extends ContextLoader> contextLoaderClass = this.resolveExplicitContextLoaderClass(configAttributesList);
        if (contextLoaderClass == null) {
            contextLoaderClass = this.getDefaultContextLoaderClass(testClass);
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)String.format("Using ContextLoader class [%s] for test class [%s]", contextLoaderClass.getName(), testClass.getName()));
        }
        return (ContextLoader)BeanUtils.instantiateClass(contextLoaderClass, ContextLoader.class);
    }

    private Class<? extends ContextLoader> resolveExplicitContextLoaderClass(List<ContextConfigurationAttributes> configAttributesList) {
        Assert.notEmpty(configAttributesList, (String)"ContextConfigurationAttributes list must not be empty");
        for (ContextConfigurationAttributes configAttributes : configAttributesList) {
            Class<? extends ContextLoader> contextLoaderClass;
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)String.format("Resolving ContextLoader for context configuration attributes %s", configAttributes));
            }
            if (ContextLoader.class.equals(contextLoaderClass = configAttributes.getContextLoaderClass())) continue;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)String.format("Found explicit ContextLoader class [%s] for context configuration attributes %s", contextLoaderClass.getName(), configAttributes));
            }
            return contextLoaderClass;
        }
        return null;
    }

    protected abstract List<String> getDefaultTestExecutionListenerClassNames();

    protected abstract Class<? extends ContextLoader> getDefaultContextLoaderClass(Class<?> var1);

    protected abstract MergedContextConfiguration buildMergedContextConfiguration(Class<?> var1, String[] var2, Class<?>[] var3, Set<Class<? extends ApplicationContextInitializer<? extends ConfigurableApplicationContext>>> var4, String[] var5, ContextLoader var6, CacheAwareContextLoaderDelegate var7, MergedContextConfiguration var8);
}

