/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context;

import java.lang.reflect.Constructor;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.test.context.BootstrapContext;
import org.springframework.test.context.BootstrapWith;
import org.springframework.test.context.CacheAwareContextLoaderDelegate;
import org.springframework.test.context.TestContextBootstrapper;
import org.springframework.util.ClassUtils;

abstract class BootstrapUtils {
    private static final String DEFAULT_BOOTSTRAP_CONTEXT_CLASS_NAME = "org.springframework.test.context.support.DefaultBootstrapContext";
    private static final String DEFAULT_CACHE_AWARE_CONTEXT_LOADER_DELEGATE_CLASS_NAME = "org.springframework.test.context.cache.DefaultCacheAwareContextLoaderDelegate";
    private static final String DEFAULT_TEST_CONTEXT_BOOTSTRAPPER_CLASS_NAME = "org.springframework.test.context.support.DefaultTestContextBootstrapper";
    private static final String DEFAULT_WEB_TEST_CONTEXT_BOOTSTRAPPER_CLASS_NAME = "org.springframework.test.context.web.WebTestContextBootstrapper";
    private static final String WEB_APP_CONFIGURATION_ANNOTATION_CLASS_NAME = "org.springframework.test.context.web.WebAppConfiguration";
    private static final Log logger = LogFactory.getLog(BootstrapUtils.class);

    BootstrapUtils() {
    }

    static BootstrapContext createBootstrapContext(Class<?> testClass) {
        CacheAwareContextLoaderDelegate cacheAwareContextLoaderDelegate = BootstrapUtils.createCacheAwareContextLoaderDelegate();
        Class clazz = null;
        try {
            clazz = ClassUtils.forName((String)DEFAULT_BOOTSTRAP_CONTEXT_CLASS_NAME, (ClassLoader)BootstrapUtils.class.getClassLoader());
            Constructor constructor = clazz.getConstructor(Class.class, CacheAwareContextLoaderDelegate.class);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)String.format("Instantiating BootstrapContext using constructor [%s]", constructor));
            }
            return (BootstrapContext)BeanUtils.instantiateClass(constructor, (Object[])new Object[]{testClass, cacheAwareContextLoaderDelegate});
        }
        catch (Throwable ex) {
            throw new IllegalStateException("Could not load BootstrapContext [" + clazz + "]", ex);
        }
    }

    private static CacheAwareContextLoaderDelegate createCacheAwareContextLoaderDelegate() {
        Class clazz = null;
        try {
            clazz = ClassUtils.forName((String)DEFAULT_CACHE_AWARE_CONTEXT_LOADER_DELEGATE_CLASS_NAME, (ClassLoader)BootstrapUtils.class.getClassLoader());
            if (logger.isDebugEnabled()) {
                logger.debug((Object)String.format("Instantiating CacheAwareContextLoaderDelegate from class [%s]", clazz.getName()));
            }
            return (CacheAwareContextLoaderDelegate)BeanUtils.instantiateClass((Class)clazz, CacheAwareContextLoaderDelegate.class);
        }
        catch (Throwable ex) {
            throw new IllegalStateException("Could not load CacheAwareContextLoaderDelegate [" + clazz + "]", ex);
        }
    }

    static TestContextBootstrapper resolveTestContextBootstrapper(BootstrapContext bootstrapContext) {
        Class<?> testClass = bootstrapContext.getTestClass();
        Class<?> clazz = null;
        try {
            clazz = BootstrapUtils.resolveExplicitTestContextBootstrapper(testClass);
            if (clazz == null) {
                clazz = BootstrapUtils.resolveDefaultTestContextBootstrapper(testClass);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)String.format("Instantiating TestContextBootstrapper for test class [%s] from class [%s]", testClass.getName(), clazz.getName()));
            }
            TestContextBootstrapper testContextBootstrapper = (TestContextBootstrapper)BeanUtils.instantiateClass(clazz, TestContextBootstrapper.class);
            testContextBootstrapper.setBootstrapContext(bootstrapContext);
            return testContextBootstrapper;
        }
        catch (Throwable ex) {
            if (ex instanceof IllegalStateException) {
                throw (IllegalStateException)ex;
            }
            throw new IllegalStateException("Could not load TestContextBootstrapper [" + clazz + "]. Specify @BootstrapWith's 'value' attribute or make the default bootstrapper class available.", ex);
        }
    }

    private static Class<?> resolveExplicitTestContextBootstrapper(Class<?> testClass) {
        Set annotations = AnnotatedElementUtils.findAllMergedAnnotations(testClass, BootstrapWith.class);
        if (annotations.size() < 1) {
            return null;
        }
        if (annotations.size() > 1) {
            throw new IllegalStateException(String.format("Configuration error: found multiple declarations of @BootstrapWith for test class [%s]: %s", testClass.getName(), annotations));
        }
        return ((BootstrapWith)annotations.iterator().next()).value();
    }

    private static Class<?> resolveDefaultTestContextBootstrapper(Class<?> testClass) throws Exception {
        ClassLoader classLoader = BootstrapUtils.class.getClassLoader();
        AnnotationAttributes attributes = AnnotatedElementUtils.findMergedAnnotationAttributes(testClass, (String)WEB_APP_CONFIGURATION_ANNOTATION_CLASS_NAME, (boolean)false, (boolean)false);
        if (attributes != null) {
            return ClassUtils.forName((String)DEFAULT_WEB_TEST_CONTEXT_BOOTSTRAPPER_CLASS_NAME, (ClassLoader)classLoader);
        }
        return ClassUtils.forName((String)DEFAULT_TEST_CONTEXT_BOOTSTRAPPER_CLASS_NAME, (ClassLoader)classLoader);
    }
}

