/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.transaction;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.test.context.TestContext;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.util.Assert;

class TransactionContext {
    private static final Log logger = LogFactory.getLog(TransactionContext.class);
    private final TestContext testContext;
    private final TransactionDefinition transactionDefinition;
    private final PlatformTransactionManager transactionManager;
    private final boolean defaultRollback;
    private boolean flaggedForRollback;
    private TransactionStatus transactionStatus;
    private volatile int transactionsStarted = 0;

    TransactionContext(TestContext testContext, PlatformTransactionManager transactionManager, TransactionDefinition transactionDefinition, boolean defaultRollback) {
        this.testContext = testContext;
        this.transactionManager = transactionManager;
        this.transactionDefinition = transactionDefinition;
        this.defaultRollback = defaultRollback;
        this.flaggedForRollback = defaultRollback;
    }

    TransactionStatus getTransactionStatus() {
        return this.transactionStatus;
    }

    boolean isFlaggedForRollback() {
        return this.flaggedForRollback;
    }

    void setFlaggedForRollback(boolean flaggedForRollback) {
        Assert.state((this.transactionStatus != null ? 1 : 0) != 0, () -> String.format("Failed to set rollback flag for test context %s: transaction does not exist.", this.testContext));
        this.flaggedForRollback = flaggedForRollback;
    }

    void startTransaction() {
        Assert.state((this.transactionStatus == null ? 1 : 0) != 0, (String)"Cannot start a new transaction without ending the existing transaction first.");
        this.flaggedForRollback = this.defaultRollback;
        this.transactionStatus = this.transactionManager.getTransaction(this.transactionDefinition);
        ++this.transactionsStarted;
        if (logger.isInfoEnabled()) {
            logger.info((Object)String.format("Began transaction (%s) for test context %s; transaction manager [%s]; rollback [%s]", this.transactionsStarted, this.testContext, this.transactionManager, this.flaggedForRollback));
        }
    }

    void endTransaction() {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)String.format("Ending transaction for test context %s; transaction status [%s]; rollback [%s]", this.testContext, this.transactionStatus, this.flaggedForRollback));
        }
        Assert.state((this.transactionStatus != null ? 1 : 0) != 0, () -> String.format("Failed to end transaction for test context %s: transaction does not exist.", this.testContext));
        try {
            if (this.flaggedForRollback) {
                this.transactionManager.rollback(this.transactionStatus);
            } else {
                this.transactionManager.commit(this.transactionStatus);
            }
        }
        finally {
            this.transactionStatus = null;
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)String.format("%s transaction for test context %s.", this.flaggedForRollback ? "Rolled back" : "Committed", this.testContext));
        }
    }
}

