/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.util;

import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.springframework.test.util.AssertionErrors;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xmlunit.builder.DiffBuilder;
import org.xmlunit.diff.Diff;

public class XmlExpectationsHelper {
    public void assertNode(String content, Matcher<? super Node> matcher) throws Exception {
        Document document = this.parseXmlString(content);
        MatcherAssert.assertThat((String)"Body content", (Object)document, matcher);
    }

    private Document parseXmlString(String xml) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        DocumentBuilder documentBuilder = factory.newDocumentBuilder();
        InputSource inputSource = new InputSource(new StringReader(xml));
        return documentBuilder.parse(inputSource);
    }

    public void assertSource(String content, Matcher<? super Source> matcher) throws Exception {
        Document document = this.parseXmlString(content);
        MatcherAssert.assertThat((String)"Body content", (Object)new DOMSource(document), matcher);
    }

    public void assertXmlEqual(String expected, String actual) throws Exception {
        Diff diffSimilar = DiffBuilder.compare((Object)expected).withTest((Object)actual).ignoreWhitespace().ignoreComments().checkForSimilar().build();
        if (diffSimilar.hasDifferences()) {
            AssertionErrors.fail("Body content " + diffSimilar.toString());
        }
    }
}

