/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.mock.http.server.reactive;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.core.io.buffer.DefaultDataBufferFactory;
import org.springframework.http.MediaType;
import org.springframework.http.server.reactive.AbstractServerHttpResponse;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class MockServerHttpResponse
extends AbstractServerHttpResponse {
    private Flux<DataBuffer> body = Flux.error((Throwable)new IllegalStateException("The body is not set. Did handling complete with success? Is a custom \"writeHandler\" configured?"));
    private Function<Flux<DataBuffer>, Mono<Void>> writeHandler = this.initDefaultWriteHandler();

    public MockServerHttpResponse() {
        super((DataBufferFactory)new DefaultDataBufferFactory());
    }

    private Function<Flux<DataBuffer>, Mono<Void>> initDefaultWriteHandler() {
        return body -> {
            this.body = body.cache();
            return this.body.then();
        };
    }

    public Flux<DataBuffer> getBody() {
        return this.body;
    }

    public Mono<String> getBodyAsString() {
        Charset charset = this.getCharset();
        return this.getBody().reduce((Object)this.bufferFactory().allocateBuffer(), (previous, current) -> {
            previous.write(new DataBuffer[]{current});
            DataBufferUtils.release((DataBuffer)current);
            return previous;
        }).map(buffer -> MockServerHttpResponse.bufferToString(buffer, charset));
    }

    private static String bufferToString(DataBuffer buffer, Charset charset) {
        Assert.notNull((Object)charset, (String)"'charset' must not be null");
        byte[] bytes = new byte[buffer.readableByteCount()];
        buffer.read(bytes);
        return new String(bytes, charset);
    }

    private Charset getCharset() {
        Charset charset = null;
        MediaType contentType = this.getHeaders().getContentType();
        if (contentType != null) {
            charset = contentType.getCharset();
        }
        return charset != null ? charset : StandardCharsets.UTF_8;
    }

    public void setWriteHandler(Function<Flux<DataBuffer>, Mono<Void>> writeHandler) {
        Assert.notNull(writeHandler, (String)"'writeHandler' is required");
        this.writeHandler = writeHandler;
    }

    protected void applyStatusCode() {
    }

    protected void applyHeaders() {
    }

    protected void applyCookies() {
    }

    protected Mono<Void> writeWithInternal(Publisher<? extends DataBuffer> body) {
        return this.writeHandler.apply((Flux<DataBuffer>)Flux.from(body));
    }

    protected Mono<Void> writeAndFlushWithInternal(Publisher<? extends Publisher<? extends DataBuffer>> body) {
        return this.writeHandler.apply((Flux<DataBuffer>)Flux.from(body).concatMap(Flux::from));
    }

    public Mono<Void> setComplete() {
        return this.doCommit(() -> Mono.defer(() -> this.writeHandler.apply((Flux<DataBuffer>)Flux.empty())));
    }
}

