/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.reactive.server;

import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseCookie;
import org.springframework.test.web.reactive.server.WiretapClientHttpRequest;
import org.springframework.test.web.reactive.server.WiretapClientHttpResponse;
import org.springframework.util.MultiValueMap;
import reactor.core.publisher.MonoProcessor;

public class ExchangeResult {
    private static final List<MediaType> PRINTABLE_MEDIA_TYPES = Arrays.asList(MediaType.APPLICATION_JSON, MediaType.APPLICATION_XML, MediaType.parseMediaType((String)"text/*"), MediaType.APPLICATION_FORM_URLENCODED);
    private final WiretapClientHttpRequest request;
    private final WiretapClientHttpResponse response;

    protected ExchangeResult(WiretapClientHttpRequest request, WiretapClientHttpResponse response) {
        this.request = request;
        this.response = response;
    }

    protected ExchangeResult(ExchangeResult other) {
        this.request = other.request;
        this.response = other.response;
    }

    public HttpMethod getMethod() {
        return this.request.getMethod();
    }

    public URI getUrl() {
        return this.request.getURI();
    }

    public HttpHeaders getRequestHeaders() {
        return this.request.getHeaders();
    }

    public MonoProcessor<byte[]> getRequestContent() {
        return this.request.getBodyContent();
    }

    public HttpStatus getStatus() {
        return this.response.getStatusCode();
    }

    public HttpHeaders getResponseHeaders() {
        return this.response.getHeaders();
    }

    public MultiValueMap<String, ResponseCookie> getResponseCookies() {
        return this.getResponseCookies();
    }

    public MonoProcessor<byte[]> getResponseContent() {
        return this.response.getBodyContent();
    }

    public void assertWithDiagnostics(Runnable assertion) {
        try {
            assertion.run();
        }
        catch (AssertionError ex) {
            throw new AssertionError("Assertion failed on the following exchange:" + this, (Throwable)((Object)ex));
        }
    }

    public String toString() {
        return "\n> " + this.getMethod() + " " + this.getUrl() + "\n> " + this.formatHeaders(this.getRequestHeaders(), "\n> ") + "\n\n" + this.formatBody(this.getRequestHeaders().getContentType(), this.getRequestContent()) + "\n\n< " + this.getStatus() + " " + this.getStatusReason() + "\n< " + this.formatHeaders(this.getResponseHeaders(), "\n< ") + "\n\n" + this.formatBody(this.getResponseHeaders().getContentType(), this.getResponseContent()) + "\n\n";
    }

    private String getStatusReason() {
        String reason = "";
        if (this.getStatus() != null && this.getStatus().getReasonPhrase() != null) {
            reason = this.getStatus().getReasonPhrase();
        }
        return reason;
    }

    private String formatHeaders(HttpHeaders headers, String delimiter) {
        return headers.entrySet().stream().map(entry -> (String)entry.getKey() + ": " + entry.getValue()).collect(Collectors.joining(delimiter));
    }

    private String formatBody(MediaType contentType, MonoProcessor<byte[]> body) {
        if (body.isSuccess()) {
            byte[] bytes = (byte[])body.blockMillis(0L);
            if (bytes.length == 0) {
                return "No content";
            }
            if (contentType == null) {
                return "Unknown content type (" + bytes.length + " bytes)";
            }
            Charset charset = contentType.getCharset();
            if (charset != null) {
                return new String(bytes, charset);
            }
            if (PRINTABLE_MEDIA_TYPES.stream().anyMatch(arg_0 -> ((MediaType)contentType).isCompatibleWith(arg_0))) {
                return new String(bytes, StandardCharsets.UTF_8);
            }
            return "Unknown charset (" + bytes.length + " bytes)";
        }
        if (body.isError()) {
            return "I/O failure: " + body.getError().getMessage();
        }
        return "Content not available yet";
    }
}

