/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.mock.http.client.reactive;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.reactivestreams.Publisher;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.core.io.buffer.DefaultDataBufferFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseCookie;
import org.springframework.http.client.reactive.ClientHttpResponse;
import org.springframework.util.Assert;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class MockClientHttpResponse
implements ClientHttpResponse {
    private final HttpStatus status;
    private final HttpHeaders headers = new HttpHeaders();
    private final MultiValueMap<String, ResponseCookie> cookies = new LinkedMultiValueMap();
    private Flux<DataBuffer> body = Flux.empty();
    private final DataBufferFactory bufferFactory = new DefaultDataBufferFactory();

    public MockClientHttpResponse(HttpStatus status) {
        Assert.notNull((Object)status, (String)"HttpStatus is required");
        this.status = status;
    }

    public HttpStatus getStatusCode() {
        return this.status;
    }

    public HttpHeaders getHeaders() {
        return this.headers;
    }

    public MultiValueMap<String, ResponseCookie> getCookies() {
        return this.cookies;
    }

    public void setBody(Publisher<DataBuffer> body) {
        this.body = Flux.from(body);
    }

    public void setBody(String body) {
        this.setBody(body, StandardCharsets.UTF_8);
    }

    public void setBody(String body, Charset charset) {
        DataBuffer buffer = this.toDataBuffer(body, charset);
        this.body = Flux.just((Object)buffer);
    }

    private DataBuffer toDataBuffer(String body, Charset charset) {
        byte[] bytes = body.getBytes(charset);
        ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
        return this.bufferFactory.wrap(byteBuffer);
    }

    public Flux<DataBuffer> getBody() {
        return this.body;
    }

    public Mono<String> getBodyAsString() {
        Charset charset = this.getCharset();
        return Flux.from(this.getBody()).reduce((Object)this.bufferFactory.allocateBuffer(), (previous, current) -> {
            previous.write(new DataBuffer[]{current});
            DataBufferUtils.release((DataBuffer)current);
            return previous;
        }).map(buffer -> MockClientHttpResponse.dumpString(buffer, charset));
    }

    private static String dumpString(DataBuffer buffer, Charset charset) {
        Assert.notNull((Object)charset, (String)"'charset' must not be null");
        byte[] bytes = new byte[buffer.readableByteCount()];
        buffer.read(bytes);
        return new String(bytes, charset);
    }

    private Charset getCharset() {
        Charset charset = null;
        MediaType contentType = this.getHeaders().getContentType();
        if (contentType != null) {
            charset = contentType.getCharset();
        }
        return charset != null ? charset : StandardCharsets.UTF_8;
    }
}

