/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.transaction.annotation;

import java.io.Serializable;
import java.lang.reflect.AnnotatedElement;
import javax.ejb.ApplicationException;
import javax.ejb.TransactionAttributeType;
import org.springframework.transaction.annotation.TransactionAnnotationParser;
import org.springframework.transaction.interceptor.DefaultTransactionAttribute;
import org.springframework.transaction.interceptor.TransactionAttribute;

public class Ejb3TransactionAnnotationParser
implements TransactionAnnotationParser,
Serializable {
    @Override
    public TransactionAttribute parseTransactionAnnotation(AnnotatedElement ae) {
        javax.ejb.TransactionAttribute ann = ae.getAnnotation(javax.ejb.TransactionAttribute.class);
        if (ann != null) {
            return this.parseTransactionAnnotation(ann);
        }
        return null;
    }

    public TransactionAttribute parseTransactionAnnotation(javax.ejb.TransactionAttribute ann) {
        return new Ejb3TransactionAttribute(ann.value());
    }

    public boolean equals(Object other) {
        return this == other || other instanceof Ejb3TransactionAnnotationParser;
    }

    public int hashCode() {
        return Ejb3TransactionAnnotationParser.class.hashCode();
    }

    private static class Ejb3TransactionAttribute
    extends DefaultTransactionAttribute {
        public Ejb3TransactionAttribute(TransactionAttributeType type) {
            this.setPropagationBehaviorName("PROPAGATION_" + type.name());
        }

        @Override
        public boolean rollbackOn(Throwable ex) {
            ApplicationException ann = ex.getClass().getAnnotation(ApplicationException.class);
            return ann != null ? ann.rollback() : super.rollbackOn(ex);
        }
    }
}

