/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.remoting.jaxrpc;

import org.aopalliance.intercept.Interceptor;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.remoting.jaxrpc.JaxRpcPortClientInterceptor;
import org.springframework.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JaxRpcPortProxyFactoryBean
extends JaxRpcPortClientInterceptor
implements FactoryBean<Object>,
BeanClassLoaderAware {
    private ClassLoader beanClassLoader = ClassUtils.getDefaultClassLoader();
    private Object serviceProxy;

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.beanClassLoader = classLoader;
    }

    @Override
    public void afterPropertiesSet() {
        if (this.getServiceInterface() == null) {
            if (this.getPortInterface() != null) {
                this.setServiceInterface(this.getPortInterface());
            } else {
                throw new IllegalArgumentException("Property 'serviceInterface' is required");
            }
        }
        super.afterPropertiesSet();
        this.serviceProxy = new ProxyFactory(this.getServiceInterface(), (Interceptor)this).getProxy(this.beanClassLoader);
    }

    public Object getObject() {
        return this.serviceProxy;
    }

    public Class<?> getObjectType() {
        return this.getServiceInterface();
    }

    public boolean isSingleton() {
        return true;
    }
}

