/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.conversation;

import java.io.Serializable;
import org.springframework.conversation.Conversation;
import org.springframework.conversation.manager.AbstractConversationRepository;
import org.springframework.conversation.manager.MutableConversation;
import org.springframework.util.Assert;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;

public class SessionBasedConversationRepository
extends AbstractConversationRepository {
    public static final String CONVERSATION_STORE_ATTR_NAME = SessionBasedConversationRepository.class.getName();

    public MutableConversation getConversation(String id) {
        RequestAttributes attributes = RequestContextHolder.currentRequestAttributes();
        Object conversation = attributes.getAttribute(this.getSessionAttributeNameForConversationId(id), 2);
        Assert.isInstanceOf(Conversation.class, (Object)conversation);
        return (MutableConversation)conversation;
    }

    public void storeConversation(MutableConversation conversation) {
        conversation.setId(this.createNextConversationId());
        RequestAttributes attributes = RequestContextHolder.currentRequestAttributes();
        String conversationSessionAttributeName = this.getSessionAttributeNameForConversationId(conversation.getId());
        attributes.setAttribute(conversationSessionAttributeName, conversation, 2);
        attributes.registerDestructionCallback(conversationSessionAttributeName, new ConversationDestructionCallback(conversation), 2);
    }

    protected void removeSingleConversationObject(MutableConversation conversation) {
        RequestAttributes attributes = RequestContextHolder.currentRequestAttributes();
        attributes.removeAttribute(this.getSessionAttributeNameForConversationId(conversation.getId()), 2);
    }

    protected String getSessionAttributeNameForConversationId(String conversationId) {
        return String.valueOf(CONVERSATION_STORE_ATTR_NAME) + conversationId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String createNextConversationId() {
        int nextAvailableConversationId = 1;
        RequestAttributes attributes = RequestContextHolder.currentRequestAttributes();
        Object object = attributes.getSessionMutex();
        synchronized (object) {
            String[] attributeNames;
            String[] stringArray = attributeNames = attributes.getAttributeNames(2);
            int n = attributeNames.length;
            int n2 = 0;
            while (n2 < n) {
                String attributeName = stringArray[n2];
                if (attributeName.startsWith(CONVERSATION_STORE_ATTR_NAME)) {
                    String conversationId;
                    int currentConversationId;
                    MutableConversation conversation = (MutableConversation)attributes.getAttribute(attributeName, 2);
                    if (conversation.isExpired()) {
                        conversation.clear();
                        attributes.removeAttribute(attributeName, 2);
                    }
                    if ((currentConversationId = Integer.parseInt(conversationId = conversation.getId())) > nextAvailableConversationId) {
                        nextAvailableConversationId = currentConversationId;
                    }
                }
                ++n2;
            }
        }
        return Integer.toString(nextAvailableConversationId);
    }

    private static final class ConversationDestructionCallback
    implements Runnable,
    Serializable {
        private final MutableConversation conversation;

        private ConversationDestructionCallback(MutableConversation conversation) {
            this.conversation = conversation;
        }

        public void run() {
            this.conversation.clear();
        }
    }
}

