/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.method.annotation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.support.DefaultDataBinderFactory;
import org.springframework.web.bind.support.WebBindingInitializer;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.InvocableHandlerMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InitBinderDataBinderFactory
extends DefaultDataBinderFactory {
    private final List<InvocableHandlerMethod> initBinderMethods;

    public InitBinderDataBinderFactory(List<InvocableHandlerMethod> binderMethods, WebBindingInitializer bindingInitializer) {
        super(bindingInitializer);
        this.initBinderMethods = binderMethods != null ? binderMethods : new ArrayList();
    }

    @Override
    public WebDataBinder createBinder(NativeWebRequest request, Object target, String objectName) throws Exception {
        WebDataBinder dataBinder = super.createBinder(request, target, objectName);
        for (InvocableHandlerMethod binderMethod : this.initBinderMethods) {
            Object returnValue;
            InitBinder annot = binderMethod.getMethodAnnotation(InitBinder.class);
            HashSet attributeNames = new HashSet(Arrays.asList(annot.value()));
            if (attributeNames.size() != 0 && !attributeNames.contains(objectName) || (returnValue = binderMethod.invokeForRequest(request, null, new Object[]{dataBinder})) == null) continue;
            throw new IllegalStateException("InitBinder methods must not have a return value: " + binderMethod);
        }
        return dataBinder;
    }
}

