/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.method.annotation.support;

import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.core.MethodParameter;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.annotation.support.AbstractNamedValueMethodArgumentResolver;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartRequest;

public class RequestParamMethodArgumentResolver
extends AbstractNamedValueMethodArgumentResolver {
    private final boolean useDefaultResolution;

    public RequestParamMethodArgumentResolver(ConfigurableBeanFactory beanFactory, boolean useDefaultResolution) {
        super(beanFactory);
        this.useDefaultResolution = useDefaultResolution;
    }

    public boolean supportsParameter(MethodParameter parameter) {
        Class paramType = parameter.getParameterType();
        RequestParam requestParamAnnot = (RequestParam)parameter.getParameterAnnotation(RequestParam.class);
        if (requestParamAnnot != null) {
            if (Map.class.isAssignableFrom(paramType)) {
                return StringUtils.hasText((String)requestParamAnnot.value());
            }
            return true;
        }
        if (this.useDefaultResolution) {
            return BeanUtils.isSimpleProperty((Class)paramType);
        }
        return false;
    }

    protected AbstractNamedValueMethodArgumentResolver.NamedValueInfo createNamedValueInfo(MethodParameter parameter) {
        RequestParam annotation = (RequestParam)parameter.getParameterAnnotation(RequestParam.class);
        return annotation != null ? new RequestParamNamedValueInfo(annotation) : new RequestParamNamedValueInfo();
    }

    protected Object resolveName(String name, MethodParameter parameter, NativeWebRequest webRequest) throws Exception {
        List<MultipartFile> files;
        MultipartRequest multipartRequest = webRequest.getNativeRequest(MultipartRequest.class);
        if (multipartRequest != null && !(files = multipartRequest.getFiles(name)).isEmpty()) {
            return files.size() == 1 ? files.get(0) : files;
        }
        String[] paramValues = webRequest.getParameterValues(name);
        if (paramValues != null) {
            return paramValues.length == 1 ? paramValues[0] : paramValues;
        }
        return null;
    }

    protected void handleMissingValue(String paramName, MethodParameter parameter) throws ServletException {
        throw new MissingServletRequestParameterException(paramName, parameter.getParameterType().getSimpleName());
    }

    private class RequestParamNamedValueInfo
    extends AbstractNamedValueMethodArgumentResolver.NamedValueInfo {
        private RequestParamNamedValueInfo() {
            super("", true, "\n\t\t\n\t\t\n\ue000\ue001\ue002\n\t\t\t\t\n");
        }

        private RequestParamNamedValueInfo(RequestParam annotation) {
            super(annotation.value(), annotation.required(), annotation.defaultValue());
        }
    }
}

