/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.accept;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.http.MediaType;
import org.springframework.util.CollectionUtils;
import org.springframework.web.accept.AbstractMappingContentNegotiationStrategy;
import org.springframework.web.accept.ContentNegotiationManager;
import org.springframework.web.accept.ContentNegotiationStrategy;
import org.springframework.web.accept.FixedContentNegotiationStrategy;
import org.springframework.web.accept.HeaderContentNegotiationStrategy;
import org.springframework.web.accept.ParameterContentNegotiationStrategy;
import org.springframework.web.accept.PathExtensionContentNegotiationStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContentNegotiationManagerFactoryBean
implements FactoryBean<ContentNegotiationManager>,
InitializingBean {
    private boolean favorPathExtension = true;
    private boolean favorParameter = false;
    private boolean ignoreAcceptHeader = false;
    private Map<String, MediaType> mediaTypes = new HashMap<String, MediaType>();
    private Boolean useJaf;
    private String parameterName;
    private MediaType defaultContentType;
    private ContentNegotiationManager contentNegotiationManager;

    public void setFavorPathExtension(boolean favorPathExtension) {
        this.favorPathExtension = favorPathExtension;
    }

    public void setMediaTypes(Properties mediaTypes) {
        if (!CollectionUtils.isEmpty((Map)mediaTypes)) {
            for (Map.Entry<Object, Object> entry : mediaTypes.entrySet()) {
                String extension = ((String)entry.getKey()).toLowerCase(Locale.ENGLISH);
                this.mediaTypes.put(extension, MediaType.valueOf((String)entry.getValue()));
            }
        }
    }

    public void setUseJaf(boolean useJaf) {
        this.useJaf = useJaf;
    }

    public void setFavorParameter(boolean favorParameter) {
        this.favorParameter = favorParameter;
    }

    public void setParameterName(String parameterName) {
        this.parameterName = parameterName;
    }

    public void setIgnoreAcceptHeader(boolean ignoreAcceptHeader) {
        this.ignoreAcceptHeader = ignoreAcceptHeader;
    }

    public void setDefaultContentType(MediaType defaultContentType) {
        this.defaultContentType = defaultContentType;
    }

    public void afterPropertiesSet() throws Exception {
        AbstractMappingContentNegotiationStrategy strategy;
        ArrayList<ContentNegotiationStrategy> strategies = new ArrayList<ContentNegotiationStrategy>();
        if (this.favorPathExtension) {
            strategy = new PathExtensionContentNegotiationStrategy(this.mediaTypes);
            if (this.useJaf != null) {
                ((PathExtensionContentNegotiationStrategy)strategy).setUseJaf(this.useJaf);
            }
            strategies.add(strategy);
        }
        if (this.favorParameter) {
            strategy = new ParameterContentNegotiationStrategy(this.mediaTypes);
            ((ParameterContentNegotiationStrategy)strategy).setParameterName(this.parameterName);
            strategies.add(strategy);
        }
        if (!this.ignoreAcceptHeader) {
            strategies.add(new HeaderContentNegotiationStrategy());
        }
        if (this.defaultContentType != null) {
            strategies.add(new FixedContentNegotiationStrategy(this.defaultContentType));
        }
        ContentNegotiationStrategy[] array = strategies.toArray(new ContentNegotiationStrategy[strategies.size()]);
        this.contentNegotiationManager = new ContentNegotiationManager(array);
    }

    public Class<?> getObjectType() {
        return ContentNegotiationManager.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public ContentNegotiationManager getObject() throws Exception {
        return this.contentNegotiationManager;
    }
}

