/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.client;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.util.FileCopyUtils;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.HttpServerErrorException;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestClientException;

public class DefaultResponseErrorHandler
implements ResponseErrorHandler {
    public boolean hasError(ClientHttpResponse response) throws IOException {
        return this.hasError(this.getStatusCode(response));
    }

    private HttpStatus getStatusCode(ClientHttpResponse response) throws IOException {
        HttpStatus statusCode;
        try {
            statusCode = response.getStatusCode();
        }
        catch (IllegalArgumentException ex) {
            throw new RestClientException("Unknown status code [" + response.getRawStatusCode() + "]");
        }
        return statusCode;
    }

    protected boolean hasError(HttpStatus statusCode) {
        return statusCode.series() == HttpStatus.Series.CLIENT_ERROR || statusCode.series() == HttpStatus.Series.SERVER_ERROR;
    }

    public void handleError(ClientHttpResponse response) throws IOException {
        HttpStatus statusCode = this.getStatusCode(response);
        HttpHeaders headers = response.getHeaders();
        MediaType contentType = headers.getContentType();
        Charset charset = contentType != null ? contentType.getCharSet() : null;
        byte[] body = this.getResponseBody(response);
        switch (statusCode.series()) {
            case CLIENT_ERROR: {
                throw new HttpClientErrorException(statusCode, response.getStatusText(), headers, body, charset);
            }
            case SERVER_ERROR: {
                throw new HttpServerErrorException(statusCode, response.getStatusText(), headers, body, charset);
            }
        }
        throw new RestClientException("Unknown status code [" + (Object)((Object)statusCode) + "]");
    }

    private byte[] getResponseBody(ClientHttpResponse response) {
        try {
            InputStream responseBody = response.getBody();
            if (responseBody != null) {
                return FileCopyUtils.copyToByteArray((InputStream)responseBody);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return new byte[0];
    }
}

