/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.context.request.async;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.task.AsyncTaskExecutor;
import org.springframework.core.task.SimpleAsyncTaskExecutor;
import org.springframework.util.Assert;
import org.springframework.web.context.request.async.AsyncTask;
import org.springframework.web.context.request.async.AsyncWebRequest;
import org.springframework.web.context.request.async.AsyncWebUtils;
import org.springframework.web.context.request.async.DeferredResult;
import org.springframework.web.util.UrlPathHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WebAsyncManager {
    private static final Object RESULT_NONE = new Object();
    private static final Log logger = LogFactory.getLog(WebAsyncManager.class);
    private AsyncWebRequest asyncWebRequest;
    private AsyncTaskExecutor taskExecutor = new SimpleAsyncTaskExecutor(this.getClass().getSimpleName());
    private Object concurrentResult = RESULT_NONE;
    private Object[] concurrentResultContext;
    private final Map<Object, WebAsyncThreadInitializer> threadInitializers = new LinkedHashMap<Object, WebAsyncThreadInitializer>();
    private static final UrlPathHelper urlPathHelper = new UrlPathHelper();

    WebAsyncManager() {
    }

    public void setAsyncWebRequest(final AsyncWebRequest asyncWebRequest) {
        Assert.notNull((Object)asyncWebRequest, (String)"AsyncWebRequest must not be null");
        Assert.state((!this.isConcurrentHandlingStarted() ? 1 : 0) != 0, (String)"Can't set AsyncWebRequest with concurrent handling in progress");
        this.asyncWebRequest = asyncWebRequest;
        this.asyncWebRequest.addCompletionHandler(new Runnable(){

            public void run() {
                asyncWebRequest.removeAttribute(AsyncWebUtils.WEB_ASYNC_MANAGER_ATTRIBUTE, 0);
            }
        });
    }

    public void setTaskExecutor(AsyncTaskExecutor taskExecutor) {
        this.taskExecutor = taskExecutor;
    }

    public boolean isConcurrentHandlingStarted() {
        return this.asyncWebRequest != null && this.asyncWebRequest.isAsyncStarted();
    }

    public boolean hasConcurrentResult() {
        return this.concurrentResult != RESULT_NONE && this.asyncWebRequest.isDispatched();
    }

    public Object getConcurrentResult() {
        return this.concurrentResult;
    }

    public Object[] getConcurrentResultContext() {
        return this.concurrentResultContext;
    }

    public void clearConcurrentResult() {
        this.concurrentResult = RESULT_NONE;
        this.concurrentResultContext = null;
    }

    public void startCallableProcessing(final Callable<?> callable, Object ... processingContext) {
        Assert.notNull(callable, (String)"Callable must not be null");
        this.startAsyncProcessing(processingContext);
        this.taskExecutor.submit(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                ArrayList initializers = new ArrayList(WebAsyncManager.this.threadInitializers.values());
                try {
                    for (WebAsyncThreadInitializer initializer : initializers) {
                        initializer.initialize();
                    }
                    WebAsyncManager.this.concurrentResult = callable.call();
                }
                catch (Throwable t) {
                    WebAsyncManager.this.concurrentResult = t;
                }
                finally {
                    Collections.reverse(initializers);
                    for (WebAsyncThreadInitializer initializer : initializers) {
                        initializer.reset();
                    }
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Concurrent result value [" + WebAsyncManager.this.concurrentResult + "]"));
                }
                if (WebAsyncManager.this.asyncWebRequest.isAsyncComplete()) {
                    logger.error((Object)"Could not complete processing due to a timeout or network error");
                    return;
                }
                logger.debug((Object)"Dispatching request to continue processing");
                WebAsyncManager.this.asyncWebRequest.dispatch();
            }
        });
    }

    public void startCallableProcessing(AsyncTask asyncTask, Object ... processingContext) {
        AsyncTaskExecutor executor;
        Assert.notNull((Object)asyncTask, (String)"AsyncTask must not be null");
        Long timeout = asyncTask.getTimeout();
        if (timeout != null) {
            this.asyncWebRequest.setTimeout(timeout);
        }
        if ((executor = asyncTask.getExecutor()) != null) {
            this.taskExecutor = executor;
        }
        this.startCallableProcessing(asyncTask.getCallable(), processingContext);
    }

    public void startDeferredResultProcessing(final DeferredResult<?> deferredResult, Object ... processingContext) {
        Assert.notNull(deferredResult, (String)"DeferredResult must not be null");
        Long timeout = deferredResult.getTimeoutMilliseconds();
        if (timeout != null) {
            this.asyncWebRequest.setTimeout(timeout);
        }
        this.asyncWebRequest.addCompletionHandler(new Runnable(){

            public void run() {
                deferredResult.setExpired();
            }
        });
        if (deferredResult.hasTimeoutResult()) {
            this.asyncWebRequest.setTimeoutHandler(new Runnable(){

                public void run() {
                    deferredResult.applyTimeoutResult();
                }
            });
        }
        this.startAsyncProcessing(processingContext);
        deferredResult.setResultHandler(new DeferredResult.DeferredResultHandler(){

            public void handleResult(Object result) {
                WebAsyncManager.this.concurrentResult = result;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Deferred result value [" + WebAsyncManager.this.concurrentResult + "]"));
                }
                Assert.state((!WebAsyncManager.this.asyncWebRequest.isAsyncComplete() ? 1 : 0) != 0, (String)("Cannot handle DeferredResult [ " + deferredResult + " ] due to a timeout or network error"));
                logger.debug((Object)"Dispatching request to complete processing");
                WebAsyncManager.this.asyncWebRequest.dispatch();
            }
        });
    }

    private void startAsyncProcessing(Object[] processingContext) {
        Assert.state((this.asyncWebRequest != null ? 1 : 0) != 0, (String)"AsyncWebRequest must not be null");
        this.asyncWebRequest.startAsync();
        this.concurrentResult = null;
        this.concurrentResultContext = processingContext;
        if (logger.isDebugEnabled()) {
            HttpServletRequest request = this.asyncWebRequest.getNativeRequest(HttpServletRequest.class);
            String requestUri = urlPathHelper.getRequestUri(request);
            logger.debug((Object)("Concurrent handling starting for " + request.getMethod() + " [" + requestUri + "]"));
        }
    }

    public void registerAsyncThreadInitializer(Object key, WebAsyncThreadInitializer initializer) {
        Assert.notNull((Object)initializer, (String)"WebAsyncThreadInitializer must not be null");
        this.threadInitializers.put(key, initializer);
    }

    public boolean initializeAsyncThread(Object key) {
        WebAsyncThreadInitializer initializer = this.threadInitializers.get(key);
        if (initializer != null) {
            initializer.initialize();
            return true;
        }
        return false;
    }

    public static interface WebAsyncThreadInitializer {
        public void initialize();

        public void reset();
    }
}

