/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.context.support;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.map.AnnotationIntrospector;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializationConfig;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JacksonObjectMapperFactoryBean
implements FactoryBean<ObjectMapper>,
InitializingBean {
    private ObjectMapper objectMapper;
    private Map<Object, Boolean> features = new HashMap<Object, Boolean>();
    private AnnotationIntrospector annotationIntrospector;
    private DateFormat dateFormat;

    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public void setAnnotationIntrospector(AnnotationIntrospector annotationIntrospector) {
        this.annotationIntrospector = annotationIntrospector;
    }

    public void setSimpleDateFormat(String format) {
        this.dateFormat = new SimpleDateFormat(format);
    }

    public void setDateFormat(DateFormat dateFormat) {
        this.dateFormat = dateFormat;
    }

    public void setAutoDetectFields(boolean autoDetectFields) {
        this.features.put(DeserializationConfig.Feature.AUTO_DETECT_FIELDS, autoDetectFields);
        this.features.put(SerializationConfig.Feature.AUTO_DETECT_FIELDS, autoDetectFields);
    }

    public void setAutoDetectGettersSetters(boolean autoDetectGettersSetters) {
        this.features.put(SerializationConfig.Feature.AUTO_DETECT_GETTERS, autoDetectGettersSetters);
        this.features.put(DeserializationConfig.Feature.AUTO_DETECT_SETTERS, autoDetectGettersSetters);
    }

    public void setFailOnEmptyBeans(boolean failOnEmptyBeans) {
        this.features.put(SerializationConfig.Feature.FAIL_ON_EMPTY_BEANS, failOnEmptyBeans);
    }

    public void setIndentOutput(boolean indentOutput) {
        this.features.put(SerializationConfig.Feature.INDENT_OUTPUT, indentOutput);
    }

    public void setFeaturesToEnable(Object[] featuresToEnable) {
        if (featuresToEnable == null) {
            throw new FatalBeanException("featuresToEnable property should not be null");
        }
        for (Object feature : featuresToEnable) {
            this.features.put(feature, Boolean.TRUE);
        }
    }

    public void setFeaturesToDisable(Object[] featuresToDisable) {
        if (featuresToDisable == null) {
            throw new FatalBeanException("featuresToDisable property should not be null");
        }
        for (Object feature : featuresToDisable) {
            this.features.put(feature, Boolean.FALSE);
        }
    }

    public ObjectMapper getObject() {
        return this.objectMapper;
    }

    public Class<?> getObjectType() {
        return ObjectMapper.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void afterPropertiesSet() throws FatalBeanException {
        if (this.objectMapper == null) {
            this.objectMapper = new ObjectMapper();
        }
        if (this.annotationIntrospector != null) {
            this.objectMapper.getSerializationConfig().setAnnotationIntrospector(this.annotationIntrospector);
            this.objectMapper.getDeserializationConfig().setAnnotationIntrospector(this.annotationIntrospector);
        }
        if (this.dateFormat != null) {
            this.objectMapper.getSerializationConfig().setDateFormat(this.dateFormat);
        }
        for (Map.Entry<Object, Boolean> entry : this.features.entrySet()) {
            this.setFeatureEnabled(entry.getKey(), entry.getValue());
        }
    }

    private void setFeatureEnabled(Object feature, boolean enabled) {
        if (feature instanceof DeserializationConfig.Feature) {
            this.objectMapper.configure((DeserializationConfig.Feature)feature, enabled);
        } else if (feature instanceof SerializationConfig.Feature) {
            this.objectMapper.configure((SerializationConfig.Feature)feature, enabled);
        } else if (feature instanceof JsonParser.Feature) {
            this.objectMapper.configure((JsonParser.Feature)feature, enabled);
        } else if (feature instanceof JsonGenerator.Feature) {
            this.objectMapper.configure((JsonGenerator.Feature)feature, enabled);
        } else {
            throw new FatalBeanException("Unknown feature class " + feature.getClass().getName());
        }
    }
}

