/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.filter;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.FormHttpMessageConverter;
import org.springframework.http.converter.xml.XmlAwareFormHttpMessageConverter;
import org.springframework.http.server.ServletServerHttpRequest;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.filter.OncePerRequestFilter;

public class HttpPutFormContentFilter
extends OncePerRequestFilter {
    private final FormHttpMessageConverter formConverter = new XmlAwareFormHttpMessageConverter();

    public void setCharset(Charset charset) {
        this.formConverter.setCharset(charset);
    }

    protected void doFilterInternal(final HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        if (("PUT".equals(request.getMethod()) || "PATCH".equals(request.getMethod())) && this.isFormContentType(request)) {
            ServletServerHttpRequest inputMessage = new ServletServerHttpRequest(request){

                public InputStream getBody() throws IOException {
                    return request.getInputStream();
                }
            };
            MultiValueMap<String, String> formParameters = this.formConverter.read((Class<? extends MultiValueMap<String, ?>>)null, (HttpInputMessage)inputMessage);
            HttpPutFormContentRequestWrapper wrapper = new HttpPutFormContentRequestWrapper(request, formParameters);
            filterChain.doFilter((ServletRequest)wrapper, (ServletResponse)response);
        } else {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
    }

    private boolean isFormContentType(HttpServletRequest request) {
        String contentType = request.getContentType();
        if (contentType != null) {
            try {
                MediaType mediaType = MediaType.parseMediaType(contentType);
                return MediaType.APPLICATION_FORM_URLENCODED.includes(mediaType);
            }
            catch (IllegalArgumentException ex) {
                return false;
            }
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class HttpPutFormContentRequestWrapper
    extends HttpServletRequestWrapper {
        private MultiValueMap<String, String> formParameters;

        public HttpPutFormContentRequestWrapper(HttpServletRequest request, MultiValueMap<String, String> parameters) {
            super(request);
            this.formParameters = parameters != null ? parameters : new LinkedMultiValueMap();
        }

        public String getParameter(String name) {
            String queryStringValue = super.getParameter(name);
            String formValue = (String)this.formParameters.getFirst((Object)name);
            return queryStringValue != null ? queryStringValue : formValue;
        }

        public Map<String, String[]> getParameterMap() {
            LinkedHashMap<String, String[]> result = new LinkedHashMap<String, String[]>();
            Enumeration<String> names = this.getParameterNames();
            while (names.hasMoreElements()) {
                String name = names.nextElement();
                result.put(name, this.getParameterValues(name));
            }
            return result;
        }

        public Enumeration<String> getParameterNames() {
            LinkedHashSet names = new LinkedHashSet();
            names.addAll(Collections.list(super.getParameterNames()));
            names.addAll(this.formParameters.keySet());
            return Collections.enumeration(names);
        }

        public String[] getParameterValues(String name) {
            String[] queryStringValues = super.getParameterValues(name);
            List formValues = (List)this.formParameters.get((Object)name);
            if (formValues == null) {
                return queryStringValues;
            }
            if (queryStringValues == null) {
                return formValues.toArray(new String[formValues.size()]);
            }
            ArrayList<String> result = new ArrayList<String>();
            result.addAll(Arrays.asList(queryStringValues));
            result.addAll(formValues);
            return result.toArray(new String[result.size()]);
        }
    }
}

