/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.context.request.async;

import java.util.List;
import java.util.concurrent.Callable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.context.request.async.CallableProcessingInterceptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CallableInterceptorChain {
    private static Log logger = LogFactory.getLog(CallableInterceptorChain.class);
    private final List<CallableProcessingInterceptor> interceptors;
    private int preProcessIndex = -1;

    public CallableInterceptorChain(List<CallableProcessingInterceptor> interceptors) {
        this.interceptors = interceptors;
    }

    public void applyPreProcess(NativeWebRequest request, Callable<?> task) throws Exception {
        for (CallableProcessingInterceptor interceptor : this.interceptors) {
            interceptor.preProcess(request, task);
            ++this.preProcessIndex;
        }
    }

    public Object applyPostProcess(NativeWebRequest request, Callable<?> task, Object concurrentResult) {
        for (int i = this.preProcessIndex; i >= 0; --i) {
            try {
                this.interceptors.get(i).postProcess(request, task, concurrentResult);
                continue;
            }
            catch (Throwable t) {
                return t;
            }
        }
        return concurrentResult;
    }

    public Object triggerAfterTimeout(NativeWebRequest request, Callable<?> task) {
        for (int i = this.interceptors.size() - 1; i >= 0; --i) {
            try {
                Object result = this.interceptors.get(i).afterTimeout(request, task);
                if (result == CallableProcessingInterceptor.RESULT_NONE) continue;
                return result;
            }
            catch (Throwable t) {
                return t;
            }
        }
        return CallableProcessingInterceptor.RESULT_NONE;
    }

    public void triggerAfterCompletion(NativeWebRequest request, Callable<?> task) {
        for (int i = this.interceptors.size() - 1; i >= 0; --i) {
            try {
                this.interceptors.get(i).afterCompletion(request, task);
                continue;
            }
            catch (Throwable t) {
                logger.error((Object)"afterCompletion error", t);
            }
        }
    }
}

