/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.client.reactive;

import io.netty.handler.codec.http.cookie.Cookie;
import java.util.Collection;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.NettyDataBufferFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseCookie;
import org.springframework.http.client.reactive.ClientHttpResponse;
import org.springframework.util.CollectionUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import reactor.core.publisher.Flux;
import reactor.ipc.netty.http.HttpInbound;

public class ReactorClientHttpResponse
implements ClientHttpResponse {
    private final NettyDataBufferFactory dataBufferFactory;
    private final HttpInbound response;

    public ReactorClientHttpResponse(HttpInbound response) {
        this.response = response;
        this.dataBufferFactory = new NettyDataBufferFactory(response.delegate().alloc());
    }

    @Override
    public Flux<DataBuffer> getBody() {
        return this.response.receive().map(buf -> {
            buf.retain();
            return this.dataBufferFactory.wrap(buf);
        });
    }

    @Override
    public HttpHeaders getHeaders() {
        HttpHeaders headers = new HttpHeaders();
        this.response.responseHeaders().entries().stream().forEach(e -> headers.add((String)e.getKey(), (String)e.getValue()));
        return headers;
    }

    @Override
    public HttpStatus getStatusCode() {
        return HttpStatus.valueOf(this.response.status().code());
    }

    @Override
    public MultiValueMap<String, ResponseCookie> getCookies() {
        LinkedMultiValueMap result = new LinkedMultiValueMap();
        this.response.cookies().values().stream().flatMap(Collection::stream).forEach(arg_0 -> ReactorClientHttpResponse.lambda$getCookies$64((MultiValueMap)result, arg_0));
        return CollectionUtils.unmodifiableMultiValueMap((MultiValueMap)result);
    }

    public String toString() {
        return "ReactorClientHttpResponse{request=" + this.response.method().name() + " " + this.response.uri() + "," + "status=" + (Object)((Object)this.getStatusCode()) + '}';
    }

    private static /* synthetic */ void lambda$getCookies$64(MultiValueMap result, Cookie cookie) {
        ResponseCookie responseCookie = ResponseCookie.from(cookie.name(), cookie.value()).domain(cookie.domain()).path(cookie.path()).maxAge(cookie.maxAge()).secure(cookie.isSecure()).httpOnly(cookie.isHttpOnly()).build();
        result.add((Object)cookie.name(), (Object)responseCookie);
    }
}

