/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.codec;

import java.io.File;
import java.io.IOException;
import java.util.Optional;
import org.reactivestreams.Publisher;
import org.springframework.core.ResolvableType;
import org.springframework.core.codec.ResourceEncoder;
import org.springframework.core.io.InputStreamResource;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.MediaTypeFactory;
import org.springframework.http.ReactiveHttpOutputMessage;
import org.springframework.http.ZeroCopyHttpOutputMessage;
import org.springframework.http.codec.EncoderHttpMessageWriter;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ResourceHttpMessageWriter
extends EncoderHttpMessageWriter<Resource> {
    public ResourceHttpMessageWriter() {
        super(new ResourceEncoder());
    }

    public ResourceHttpMessageWriter(int bufferSize) {
        super(new ResourceEncoder(bufferSize));
    }

    @Override
    public Mono<Void> write(Publisher<? extends Resource> inputStream, ResolvableType type, MediaType contentType, ReactiveHttpOutputMessage outputMessage) {
        return Mono.from((Publisher)Flux.from(inputStream).take(1L).concatMap(resource -> {
            HttpHeaders headers = outputMessage.getHeaders();
            this.addHeaders(headers, (Resource)resource, contentType);
            return this.writeContent((Resource)resource, type, outputMessage);
        }));
    }

    protected void addHeaders(HttpHeaders headers, Resource resource, MediaType contentType) {
        if (headers.getContentType() == null) {
            if (contentType == null || !contentType.isConcrete() || MediaType.APPLICATION_OCTET_STREAM.equals(contentType)) {
                contentType = Optional.ofNullable(MediaTypeFactory.getMediaType(resource)).orElse(MediaType.APPLICATION_OCTET_STREAM);
            }
            headers.setContentType(contentType);
        }
        if (headers.getContentLength() < 0L) {
            ResourceHttpMessageWriter.contentLength(resource).ifPresent(headers::setContentLength);
        }
    }

    private Mono<Void> writeContent(Resource resource, ResolvableType type, ReactiveHttpOutputMessage outputMessage) {
        Optional<File> file;
        if (outputMessage instanceof ZeroCopyHttpOutputMessage && (file = ResourceHttpMessageWriter.getFile(resource)).isPresent()) {
            ZeroCopyHttpOutputMessage zeroCopyResponse = (ZeroCopyHttpOutputMessage)outputMessage;
            return zeroCopyResponse.writeWith(file.get(), 0L, file.get().length());
        }
        return super.write(Mono.just((Object)resource), type, outputMessage.getHeaders().getContentType(), outputMessage);
    }

    private static Optional<Long> contentLength(Resource resource) {
        if (InputStreamResource.class != resource.getClass()) {
            try {
                return Optional.of(resource.contentLength());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return Optional.empty();
    }

    private static Optional<File> getFile(Resource resource) {
        if (resource.isFile()) {
            try {
                return Optional.of(resource.getFile());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return Optional.empty();
    }
}

