/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.server.reactive;

import java.util.function.Function;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.core.io.buffer.NettyDataBufferFactory;
import org.springframework.http.server.reactive.HttpHandler;
import org.springframework.http.server.reactive.ReactorServerHttpRequest;
import org.springframework.http.server.reactive.ReactorServerHttpResponse;
import org.springframework.util.Assert;
import reactor.core.publisher.Mono;
import reactor.ipc.netty.http.HttpChannel;

public class ReactorHttpHandlerAdapter
implements Function<HttpChannel, Mono<Void>> {
    private final HttpHandler httpHandler;

    public ReactorHttpHandlerAdapter(HttpHandler httpHandler) {
        Assert.notNull((Object)httpHandler, (String)"'httpHandler' is required.");
        this.httpHandler = httpHandler;
    }

    @Override
    public Mono<Void> apply(HttpChannel channel) {
        NettyDataBufferFactory bufferFactory = new NettyDataBufferFactory(channel.delegate().alloc());
        ReactorServerHttpRequest adaptedRequest = new ReactorServerHttpRequest(channel, bufferFactory);
        ReactorServerHttpResponse adaptedResponse = new ReactorServerHttpResponse(channel, (DataBufferFactory)bufferFactory);
        return this.httpHandler.handle(adaptedRequest, adaptedResponse);
    }
}

