/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.server.reactive;

import java.io.IOException;
import javax.servlet.AsyncContext;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.core.io.buffer.DefaultDataBufferFactory;
import org.springframework.http.server.reactive.HttpHandler;
import org.springframework.http.server.reactive.ServletServerHttpRequest;
import org.springframework.http.server.reactive.ServletServerHttpResponse;
import org.springframework.util.Assert;

@WebServlet(asyncSupported=true)
public class ServletHttpHandlerAdapter
extends HttpServlet {
    private static final int DEFAULT_BUFFER_SIZE = 8192;
    private static Log logger = LogFactory.getLog(ServletHttpHandlerAdapter.class);
    private HttpHandler handler;
    private DataBufferFactory dataBufferFactory = new DefaultDataBufferFactory(false);
    private int bufferSize = 8192;

    public void setHandler(HttpHandler handler) {
        Assert.notNull((Object)handler, (String)"'handler' must not be null");
        this.handler = handler;
    }

    public void setDataBufferFactory(DataBufferFactory dataBufferFactory) {
        Assert.notNull((Object)dataBufferFactory, (String)"'dataBufferFactory' must not be null");
        this.dataBufferFactory = dataBufferFactory;
    }

    public void setBufferSize(int bufferSize) {
        Assert.isTrue((bufferSize > 0 ? 1 : 0) != 0);
        this.bufferSize = bufferSize;
    }

    protected void service(HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws ServletException, IOException {
        AsyncContext asyncContext = servletRequest.startAsync();
        ServletServerHttpRequest request = new ServletServerHttpRequest(servletRequest, this.dataBufferFactory, this.bufferSize);
        ServletServerHttpResponse response = new ServletServerHttpResponse(servletResponse, this.dataBufferFactory, this.bufferSize);
        HandlerResultSubscriber resultSubscriber = new HandlerResultSubscriber(asyncContext);
        this.handler.handle(request, response).subscribe((Subscriber)resultSubscriber);
    }

    private static class HandlerResultSubscriber
    implements Subscriber<Void> {
        private final AsyncContext asyncContext;

        public HandlerResultSubscriber(AsyncContext asyncContext) {
            this.asyncContext = asyncContext;
        }

        public void onSubscribe(Subscription subscription) {
            subscription.request(Long.MAX_VALUE);
        }

        public void onNext(Void aVoid) {
        }

        public void onError(Throwable ex) {
            logger.error((Object)"Error from request handling. Completing the request.", ex);
            HttpServletResponse response = (HttpServletResponse)this.asyncContext.getResponse();
            response.setStatus(500);
            this.asyncContext.complete();
        }

        public void onComplete() {
            this.asyncContext.complete();
        }
    }
}

