/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.server.reactive;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.WriteListener;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import org.reactivestreams.Processor;
import org.reactivestreams.Publisher;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseCookie;
import org.springframework.http.server.reactive.AbstractListenerServerHttpResponse;
import org.springframework.http.server.reactive.AbstractResponseBodyFlushProcessor;
import org.springframework.http.server.reactive.AbstractResponseBodyProcessor;
import org.springframework.util.Assert;

public class ServletServerHttpResponse
extends AbstractListenerServerHttpResponse {
    private final ResponseBodyWriteListener writeListener = new ResponseBodyWriteListener();
    private volatile ResponseBodyProcessor bodyProcessor;
    private final HttpServletResponse response;
    private final int bufferSize;
    private volatile boolean flushOnNext;

    public ServletServerHttpResponse(HttpServletResponse response, DataBufferFactory dataBufferFactory, int bufferSize) throws IOException {
        super(dataBufferFactory);
        Assert.notNull((Object)response, (String)"'response' must not be null");
        Assert.notNull((Object)dataBufferFactory, (String)"'dataBufferFactory' must not be null");
        Assert.isTrue((bufferSize > 0 ? 1 : 0) != 0);
        this.response = response;
        this.bufferSize = bufferSize;
    }

    public HttpServletResponse getServletResponse() {
        return this.response;
    }

    @Override
    protected void writeStatusCode() {
        HttpStatus statusCode = this.getStatusCode();
        if (statusCode != null) {
            this.getServletResponse().setStatus(statusCode.value());
        }
    }

    @Override
    protected void writeHeaders() {
        Charset charset;
        for (Map.Entry<String, List<String>> entry : this.getHeaders().entrySet()) {
            String headerName = entry.getKey();
            for (String headerValue : entry.getValue()) {
                this.response.addHeader(headerName, headerValue);
            }
        }
        MediaType contentType = this.getHeaders().getContentType();
        if (this.response.getContentType() == null && contentType != null) {
            this.response.setContentType(contentType.toString());
        }
        Charset charset2 = charset = contentType != null ? contentType.getCharset() : null;
        if (this.response.getCharacterEncoding() == null && charset != null) {
            this.response.setCharacterEncoding(charset.name());
        }
    }

    @Override
    protected void writeCookies() {
        for (String name : this.getCookies().keySet()) {
            for (ResponseCookie httpCookie : (List)this.getCookies().get((Object)name)) {
                Cookie cookie = new Cookie(name, httpCookie.getValue());
                if (!httpCookie.getMaxAge().isNegative()) {
                    cookie.setMaxAge((int)httpCookie.getMaxAge().getSeconds());
                }
                httpCookie.getDomain().ifPresent(arg_0 -> ((Cookie)cookie).setDomain(arg_0));
                httpCookie.getPath().ifPresent(arg_0 -> ((Cookie)cookie).setPath(arg_0));
                cookie.setSecure(httpCookie.isSecure());
                cookie.setHttpOnly(httpCookie.isHttpOnly());
                this.response.addCookie(cookie);
            }
        }
    }

    @Override
    protected Processor<Publisher<DataBuffer>, Void> createBodyFlushProcessor() {
        ResponseBodyFlushProcessor processor = new ResponseBodyFlushProcessor();
        this.registerListener();
        return processor;
    }

    private void registerListener() {
        try {
            this.outputStream().setWriteListener((WriteListener)this.writeListener);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private ServletOutputStream outputStream() throws IOException {
        return this.response.getOutputStream();
    }

    private void flush() throws IOException {
        ServletOutputStream outputStream = this.outputStream();
        if (outputStream.isReady()) {
            try {
                outputStream.flush();
                this.flushOnNext = false;
            }
            catch (IOException ex) {
                this.flushOnNext = true;
                throw ex;
            }
        } else {
            this.flushOnNext = true;
        }
    }

    private class ResponseBodyFlushProcessor
    extends AbstractResponseBodyFlushProcessor {
        private ResponseBodyFlushProcessor() {
        }

        @Override
        protected Processor<DataBuffer, Void> createBodyProcessor() {
            try {
                ServletServerHttpResponse.this.bodyProcessor = new ResponseBodyProcessor(ServletServerHttpResponse.this.outputStream(), ServletServerHttpResponse.this.bufferSize);
                return ServletServerHttpResponse.this.bodyProcessor;
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
        }

        @Override
        protected void flush() throws IOException {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)"flush");
            }
            ServletServerHttpResponse.this.flush();
        }
    }

    private class ResponseBodyWriteListener
    implements WriteListener {
        private ResponseBodyWriteListener() {
        }

        public void onWritePossible() throws IOException {
            if (ServletServerHttpResponse.this.bodyProcessor != null) {
                ServletServerHttpResponse.this.bodyProcessor.onWritePossible();
            }
        }

        public void onError(Throwable ex) {
            if (ServletServerHttpResponse.this.bodyProcessor != null) {
                ServletServerHttpResponse.this.bodyProcessor.cancel();
                ServletServerHttpResponse.this.bodyProcessor.onError(ex);
            }
        }
    }

    private class ResponseBodyProcessor
    extends AbstractResponseBodyProcessor {
        private final ServletOutputStream outputStream;
        private final int bufferSize;

        public ResponseBodyProcessor(ServletOutputStream outputStream, int bufferSize) {
            this.outputStream = outputStream;
            this.bufferSize = bufferSize;
        }

        @Override
        protected boolean isWritePossible() {
            return this.outputStream.isReady();
        }

        @Override
        protected boolean write(DataBuffer dataBuffer) throws IOException {
            if (ServletServerHttpResponse.this.flushOnNext) {
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace((Object)"flush");
                }
                ServletServerHttpResponse.this.flush();
            }
            boolean ready = this.outputStream.isReady();
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("write: " + dataBuffer + " ready: " + ready));
            }
            if (ready) {
                int total = dataBuffer.readableByteCount();
                int written = this.writeDataBuffer(dataBuffer);
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace((Object)("written: " + written + " total: " + total));
                }
                return written == total;
            }
            return false;
        }

        private int writeDataBuffer(DataBuffer dataBuffer) throws IOException {
            InputStream input = dataBuffer.asInputStream();
            int bytesWritten = 0;
            byte[] buffer = new byte[this.bufferSize];
            int bytesRead = -1;
            while (this.outputStream.isReady() && (bytesRead = input.read(buffer)) != -1) {
                this.outputStream.write(buffer, 0, bytesRead);
                bytesWritten += bytesRead;
            }
            return bytesWritten;
        }
    }
}

