/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.client.reactive.support;

import java.net.URI;
import org.reactivestreams.Publisher;
import org.springframework.core.ResolvableType;
import org.springframework.http.HttpCookie;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.reactive.ClientWebRequest;
import org.springframework.web.client.reactive.ClientWebRequestBuilder;
import org.springframework.web.client.reactive.ClientWebRequestPostProcessor;
import org.springframework.web.client.reactive.DefaultClientWebRequestBuilder;
import reactor.adapter.RxJava1Adapter;
import reactor.core.publisher.Mono;
import rx.Observable;
import rx.Single;

public class RxJava1ClientWebRequestBuilder
implements ClientWebRequestBuilder {
    private final DefaultClientWebRequestBuilder delegate;

    public RxJava1ClientWebRequestBuilder(HttpMethod httpMethod, String urlTemplate, Object ... urlVariables) throws RestClientException {
        this.delegate = new DefaultClientWebRequestBuilder(httpMethod, urlTemplate, urlVariables);
    }

    public RxJava1ClientWebRequestBuilder(HttpMethod httpMethod, URI url) {
        this.delegate = new DefaultClientWebRequestBuilder(httpMethod, url);
    }

    public RxJava1ClientWebRequestBuilder header(String name, String ... values) {
        this.delegate.header(name, values);
        return this;
    }

    public RxJava1ClientWebRequestBuilder headers(HttpHeaders httpHeaders) {
        this.delegate.headers(httpHeaders);
        return this;
    }

    public RxJava1ClientWebRequestBuilder contentType(MediaType contentType) {
        this.delegate.contentType(contentType);
        return this;
    }

    public RxJava1ClientWebRequestBuilder contentType(String contentType) {
        this.delegate.contentType(contentType);
        return this;
    }

    public RxJava1ClientWebRequestBuilder accept(MediaType ... mediaTypes) {
        this.delegate.accept(mediaTypes);
        return this;
    }

    public RxJava1ClientWebRequestBuilder accept(String ... mediaTypes) {
        this.delegate.accept(mediaTypes);
        return this;
    }

    public RxJava1ClientWebRequestBuilder cookie(String name, String value) {
        this.delegate.cookie(name, value);
        return this;
    }

    public RxJava1ClientWebRequestBuilder cookie(HttpCookie cookie) {
        this.delegate.cookie(cookie);
        return this;
    }

    public RxJava1ClientWebRequestBuilder apply(ClientWebRequestPostProcessor postProcessor) {
        this.delegate.apply(postProcessor);
        return this;
    }

    public RxJava1ClientWebRequestBuilder body(Object content) {
        this.delegate.body((Publisher<?>)Mono.just((Object)content), ResolvableType.forInstance((Object)content));
        return this;
    }

    public RxJava1ClientWebRequestBuilder body(Single<?> content, ResolvableType elementType) {
        this.delegate.body((Publisher<?>)RxJava1Adapter.singleToMono(content), elementType);
        return this;
    }

    public RxJava1ClientWebRequestBuilder body(Observable<?> content, ResolvableType elementType) {
        this.delegate.body((Publisher<?>)RxJava1Adapter.observableToFlux(content), elementType);
        return this;
    }

    @Override
    public ClientWebRequest build() {
        return this.delegate.build();
    }
}

