/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.server.adapter;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.util.Assert;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebSession;
import org.springframework.web.server.session.WebSessionManager;
import reactor.core.publisher.Mono;

public class DefaultServerWebExchange
implements ServerWebExchange {
    private final ServerHttpRequest request;
    private final ServerHttpResponse response;
    private final Map<String, Object> attributes = new ConcurrentHashMap<String, Object>();
    private final Mono<WebSession> sessionMono;

    public DefaultServerWebExchange(ServerHttpRequest request, ServerHttpResponse response, WebSessionManager sessionManager) {
        Assert.notNull((Object)request, (String)"'request' is required.");
        Assert.notNull((Object)response, (String)"'response' is required.");
        Assert.notNull((Object)response, (String)"'sessionManager' is required.");
        this.request = request;
        this.response = response;
        this.sessionMono = sessionManager.getSession(this).cache();
    }

    @Override
    public ServerHttpRequest getRequest() {
        return this.request;
    }

    @Override
    public ServerHttpResponse getResponse() {
        return this.response;
    }

    @Override
    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    @Override
    public <T> Optional<T> getAttribute(String name) {
        return Optional.ofNullable(this.attributes.get(name));
    }

    @Override
    public Mono<WebSession> getSession() {
        return this.sessionMono;
    }
}

