/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.codec;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.reactivestreams.Publisher;
import org.springframework.core.ResolvableType;
import org.springframework.core.codec.Encoder;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ReactiveHttpOutputMessage;
import org.springframework.http.codec.HttpMessageWriter;
import org.springframework.util.MimeType;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class EncoderHttpMessageWriter<T>
implements HttpMessageWriter<T> {
    private final Encoder<T> encoder;
    private final List<MediaType> writableMediaTypes;

    public EncoderHttpMessageWriter(Encoder<T> encoder) {
        this.encoder = encoder;
        this.writableMediaTypes = encoder != null ? MediaType.asMediaTypes(encoder.getEncodableMimeTypes()) : Collections.emptyList();
    }

    @Override
    public boolean canWrite(ResolvableType elementType, MediaType mediaType) {
        return this.encoder != null && this.encoder.canEncode(elementType, (MimeType)mediaType);
    }

    @Override
    public List<MediaType> getWritableMediaTypes() {
        return this.writableMediaTypes;
    }

    @Override
    public Mono<Void> write(Publisher<? extends T> inputStream, ResolvableType elementType, MediaType mediaType, ReactiveHttpOutputMessage outputMessage, Map<String, Object> hints) {
        if (this.encoder == null) {
            return Mono.error((Throwable)new IllegalStateException("No decoder set"));
        }
        HttpHeaders headers = outputMessage.getHeaders();
        if (headers.getContentType() == null) {
            MediaType contentType;
            MediaType contentTypeToUse = mediaType;
            if (mediaType == null || mediaType.isWildcardType() || mediaType.isWildcardSubtype()) {
                contentTypeToUse = this.getDefaultContentType(elementType);
            } else if (MediaType.APPLICATION_OCTET_STREAM.equals(mediaType)) {
                contentType = this.getDefaultContentType(elementType);
                MediaType mediaType2 = contentTypeToUse = contentType != null ? contentType : contentTypeToUse;
            }
            if (contentTypeToUse != null) {
                if (contentTypeToUse.getCharset() == null && (contentType = this.getDefaultContentType(elementType)) != null && contentType.getCharset() != null) {
                    contentTypeToUse = new MediaType(contentTypeToUse, contentType.getCharset());
                }
                headers.setContentType(contentTypeToUse);
            }
        }
        DataBufferFactory bufferFactory = outputMessage.bufferFactory();
        Flux body = this.encoder.encode(inputStream, bufferFactory, elementType, (MimeType)mediaType, hints);
        return outputMessage.writeWith((Publisher<DataBuffer>)body);
    }

    protected MediaType getDefaultContentType(ResolvableType elementType) {
        return !this.writableMediaTypes.isEmpty() ? this.writableMediaTypes.get(0) : null;
    }
}

