/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.server.reactive;

import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.reactivestreams.Processor;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.http.server.reactive.ResponseBodyWriteResultPublisher;
import org.springframework.util.Assert;

abstract class AbstractResponseBodyProcessor
implements Processor<DataBuffer, Void> {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final ResponseBodyWriteResultPublisher resultPublisher = new ResponseBodyWriteResultPublisher();
    private final AtomicReference<State> state = new AtomicReference<State>(State.UNSUBSCRIBED);
    private volatile DataBuffer currentBuffer;
    private volatile boolean subscriberCompleted;
    private Subscription subscription;

    AbstractResponseBodyProcessor() {
    }

    public final void onSubscribe(Subscription subscription) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)(this.state + " onSubscribe: " + subscription));
        }
        this.state.get().onSubscribe(this, subscription);
    }

    public final void onNext(DataBuffer dataBuffer) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)(this.state + " onNext: " + dataBuffer));
        }
        this.state.get().onNext(this, dataBuffer);
    }

    public final void onError(Throwable t) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)(this.state + " onError: " + t));
        }
        this.state.get().onError(this, t);
    }

    public final void onComplete() {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)(this.state + " onComplete"));
        }
        this.state.get().onComplete(this);
    }

    public final void subscribe(Subscriber<? super Void> subscriber) {
        this.resultPublisher.subscribe(subscriber);
    }

    protected final void onWritePossible() {
        this.state.get().onWritePossible(this);
    }

    protected void receiveBuffer(DataBuffer dataBuffer) {
        Assert.state((this.currentBuffer == null ? 1 : 0) != 0);
        this.currentBuffer = dataBuffer;
    }

    protected void releaseBuffer() {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("releaseBuffer: " + this.currentBuffer));
        }
        DataBufferUtils.release((DataBuffer)this.currentBuffer);
        this.currentBuffer = null;
    }

    private void writeIfPossible() {
        if (this.isWritePossible()) {
            this.onWritePossible();
        }
    }

    protected boolean isWritePossible() {
        return false;
    }

    protected abstract boolean write(DataBuffer var1) throws IOException;

    protected void cancel() {
        this.subscription.cancel();
    }

    private boolean changeState(State oldState, State newState) {
        return this.state.compareAndSet(oldState, newState);
    }

    private static enum State {
        UNSUBSCRIBED{

            @Override
            public void onSubscribe(AbstractResponseBodyProcessor processor, Subscription subscription) {
                Objects.requireNonNull(subscription, "Subscription cannot be null");
                if (processor.changeState(this, 1.REQUESTED)) {
                    processor.subscription = subscription;
                    subscription.request(1L);
                } else {
                    super.onSubscribe(processor, subscription);
                }
            }
        }
        ,
        REQUESTED{

            @Override
            public void onNext(AbstractResponseBodyProcessor processor, DataBuffer dataBuffer) {
                if (processor.changeState(this, 2.RECEIVED)) {
                    processor.receiveBuffer(dataBuffer);
                    processor.writeIfPossible();
                }
            }

            @Override
            public void onComplete(AbstractResponseBodyProcessor processor) {
                if (processor.changeState(this, 2.COMPLETED)) {
                    processor.resultPublisher.publishComplete();
                }
            }
        }
        ,
        RECEIVED{

            @Override
            public void onWritePossible(AbstractResponseBodyProcessor processor) {
                if (processor.changeState(this, 3.WRITING)) {
                    DataBuffer dataBuffer = processor.currentBuffer;
                    try {
                        boolean writeCompleted = processor.write(dataBuffer);
                        if (writeCompleted) {
                            processor.releaseBuffer();
                            if (!processor.subscriberCompleted) {
                                processor.changeState(3.WRITING, 3.REQUESTED);
                                processor.subscription.request(1L);
                            } else {
                                processor.changeState(3.WRITING, 3.COMPLETED);
                                processor.resultPublisher.publishComplete();
                            }
                        } else {
                            processor.changeState(3.WRITING, 3.RECEIVED);
                            processor.writeIfPossible();
                        }
                    }
                    catch (IOException ex) {
                        processor.cancel();
                        processor.onError(ex);
                    }
                }
            }

            @Override
            public void onComplete(AbstractResponseBodyProcessor processor) {
                processor.subscriberCompleted = true;
            }
        }
        ,
        WRITING{

            @Override
            public void onComplete(AbstractResponseBodyProcessor processor) {
                processor.subscriberCompleted = true;
            }
        }
        ,
        COMPLETED{

            @Override
            public void onNext(AbstractResponseBodyProcessor processor, DataBuffer dataBuffer) {
            }

            @Override
            public void onError(AbstractResponseBodyProcessor processor, Throwable ex) {
            }

            @Override
            public void onComplete(AbstractResponseBodyProcessor processor) {
            }
        };


        public void onSubscribe(AbstractResponseBodyProcessor processor, Subscription subscription) {
            subscription.cancel();
        }

        public void onNext(AbstractResponseBodyProcessor processor, DataBuffer dataBuffer) {
            throw new IllegalStateException(this.toString());
        }

        public void onError(AbstractResponseBodyProcessor processor, Throwable ex) {
            if (processor.changeState(this, State.COMPLETED)) {
                processor.resultPublisher.publishError(ex);
            }
        }

        public void onComplete(AbstractResponseBodyProcessor processor) {
            throw new IllegalStateException(this.toString());
        }

        public void onWritePossible(AbstractResponseBodyProcessor processor) {
        }
    }
}

