/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.client.reactive;

import java.nio.charset.Charset;
import java.util.Base64;
import org.springframework.util.Assert;
import org.springframework.web.client.reactive.ClientWebRequest;
import org.springframework.web.client.reactive.ClientWebRequestPostProcessor;

public abstract class ClientWebRequestPostProcessors {
    public static ClientWebRequestPostProcessor httpBasic(final String username, final String password) {
        Assert.notNull((Object)username, (String)"username cannot be null");
        Assert.notNull((Object)password, (String)"password cannot be null");
        return new ClientWebRequestPostProcessor(){

            @Override
            public ClientWebRequest postProcess(ClientWebRequest toPostProcess) {
                String authorization = this.authorization(username, password);
                toPostProcess.getHttpHeaders().set("Authorization", authorization);
                return toPostProcess;
            }

            private String authorization(String username2, String password2) {
                String credentials = username2 + ":" + password2;
                return this.authorization(credentials);
            }

            private String authorization(String credentials) {
                byte[] credentialBytes = credentials.getBytes(Charset.defaultCharset());
                Base64.Encoder encoder = Base64.getEncoder();
                String encodedCredentials = encoder.encodeToString(credentialBytes);
                return "Basic " + encodedCredentials;
            }
        };
    }
}

