/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.server.session;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.web.server.WebSession;
import org.springframework.web.server.session.WebSessionStore;
import reactor.core.publisher.Mono;

public class InMemoryWebSessionStore
implements WebSessionStore {
    private final Map<String, WebSession> sessions = new ConcurrentHashMap<String, WebSession>();

    @Override
    public Mono<Void> storeSession(WebSession session) {
        this.sessions.put(session.getId(), session);
        return Mono.empty();
    }

    @Override
    public Mono<WebSession> retrieveSession(String id) {
        return this.sessions.containsKey(id) ? Mono.just((Object)this.sessions.get(id)) : Mono.empty();
    }

    @Override
    public Mono<Void> removeSession(String id) {
        this.sessions.remove(id);
        return Mono.empty();
    }
}

