/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.codec;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.core.ResolvableType;
import org.springframework.http.MediaType;
import org.springframework.http.ReactiveHttpInputMessage;
import org.springframework.http.codec.HttpMessageReader;
import org.springframework.http.codec.ServerHttpMessageReader;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public abstract class AbstractServerHttpMessageReader<T>
implements ServerHttpMessageReader<T> {
    private HttpMessageReader<T> reader;

    public AbstractServerHttpMessageReader(HttpMessageReader<T> reader) {
        this.reader = reader;
    }

    @Override
    public boolean canRead(ResolvableType elementType, MediaType mediaType) {
        return this.reader.canRead(elementType, mediaType);
    }

    @Override
    public Flux<T> read(ResolvableType elementType, ReactiveHttpInputMessage inputMessage, Map<String, Object> hints) {
        return this.reader.read(elementType, inputMessage, hints);
    }

    @Override
    public Mono<T> readMono(ResolvableType elementType, ReactiveHttpInputMessage inputMessage, Map<String, Object> hints) {
        return this.reader.readMono(elementType, inputMessage, hints);
    }

    @Override
    public List<MediaType> getReadableMediaTypes() {
        return this.reader.getReadableMediaTypes();
    }

    @Override
    public Flux<T> read(ResolvableType streamType, ResolvableType elementType, ServerHttpRequest request, ServerHttpResponse response, Map<String, Object> hints) {
        HashMap<String, Object> mergedHints = new HashMap<String, Object>(hints);
        mergedHints.putAll(this.resolveReadHints(streamType, elementType, request));
        return this.reader instanceof ServerHttpMessageReader ? ((ServerHttpMessageReader)this.reader).read(streamType, elementType, request, response, mergedHints) : this.read(elementType, request, mergedHints);
    }

    @Override
    public Mono<T> readMono(ResolvableType streamType, ResolvableType elementType, ServerHttpRequest request, ServerHttpResponse response, Map<String, Object> hints) {
        HashMap<String, Object> mergedHints = new HashMap<String, Object>(hints);
        mergedHints.putAll(this.resolveReadHints(streamType, elementType, request));
        return this.reader instanceof ServerHttpMessageReader ? ((ServerHttpMessageReader)this.reader).readMono(streamType, elementType, request, response, mergedHints) : this.readMono(elementType, request, mergedHints);
    }

    protected abstract Map<String, Object> resolveReadHints(ResolvableType var1, ResolvableType var2, ServerHttpRequest var3);
}

