/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.codec.json;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import org.reactivestreams.Publisher;
import org.springframework.core.ResolvableType;
import org.springframework.core.codec.CodecException;
import org.springframework.core.codec.Encoder;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.http.codec.json.AbstractJackson2Codec;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;
import org.springframework.util.Assert;
import org.springframework.util.MimeType;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class Jackson2JsonEncoder
extends AbstractJackson2Codec
implements Encoder<Object> {
    private static final ByteBuffer START_ARRAY_BUFFER = ByteBuffer.wrap(new byte[]{91});
    private static final ByteBuffer SEPARATOR_BUFFER = ByteBuffer.wrap(new byte[]{44});
    private static final ByteBuffer END_ARRAY_BUFFER = ByteBuffer.wrap(new byte[]{93});

    public Jackson2JsonEncoder() {
        super((ObjectMapper)Jackson2ObjectMapperBuilder.json().build());
    }

    public Jackson2JsonEncoder(ObjectMapper mapper) {
        super(mapper);
    }

    public boolean canEncode(ResolvableType elementType, MimeType mimeType) {
        return this.mapper.canSerialize(elementType.getRawClass()) && (mimeType == null || JSON_MIME_TYPES.stream().anyMatch(m -> m.isCompatibleWith(mimeType)));
    }

    public List<MimeType> getEncodableMimeTypes() {
        return JSON_MIME_TYPES;
    }

    public Flux<DataBuffer> encode(Publisher<?> inputStream, DataBufferFactory bufferFactory, ResolvableType elementType, MimeType mimeType, Map<String, Object> hints) {
        Assert.notNull(inputStream, (String)"'inputStream' must not be null");
        Assert.notNull((Object)bufferFactory, (String)"'bufferFactory' must not be null");
        Assert.notNull((Object)elementType, (String)"'elementType' must not be null");
        if (inputStream instanceof Mono) {
            return Flux.from(inputStream).map(value -> this.encodeValue(value, bufferFactory, elementType, hints));
        }
        Mono startArray = Mono.just((Object)bufferFactory.wrap(START_ARRAY_BUFFER));
        Mono endArray = Mono.just((Object)bufferFactory.wrap(END_ARRAY_BUFFER));
        Flux array = Flux.from(inputStream).concatMap(value -> {
            DataBuffer arraySeparator = bufferFactory.wrap(SEPARATOR_BUFFER);
            return Flux.just((Object[])new DataBuffer[]{this.encodeValue(value, bufferFactory, elementType, hints), arraySeparator});
        });
        return Flux.concat((Publisher[])new Publisher[]{startArray, array.skipLast(1), endArray});
    }

    private DataBuffer encodeValue(Object value, DataBufferFactory bufferFactory, ResolvableType type, Map<String, Object> hints) {
        Class jsonView;
        TypeFactory typeFactory = this.mapper.getTypeFactory();
        JavaType javaType = typeFactory.constructType(type.getType());
        if (type.isInstance(value)) {
            javaType = this.getJavaType(type.getType(), null);
        }
        ObjectWriter writer = (jsonView = (Class)hints.get(AbstractJackson2Codec.JSON_VIEW_HINT)) != null ? this.mapper.writerWithView(jsonView) : this.mapper.writer();
        if (javaType != null && javaType.isContainerType()) {
            writer = writer.forType(javaType);
        }
        DataBuffer buffer = bufferFactory.allocateBuffer();
        OutputStream outputStream = buffer.asOutputStream();
        try {
            writer.writeValue(outputStream, value);
        }
        catch (IOException ex) {
            throw new CodecException("Error while writing the data", (Throwable)ex);
        }
        return buffer;
    }
}

