/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.server.reactive;

import java.util.concurrent.atomic.AtomicBoolean;
import org.reactivestreams.Processor;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.http.server.reactive.AbstractServerHttpResponse;
import reactor.core.publisher.Mono;

public abstract class AbstractListenerServerHttpResponse
extends AbstractServerHttpResponse {
    private final AtomicBoolean writeCalled = new AtomicBoolean();

    public AbstractListenerServerHttpResponse(DataBufferFactory dataBufferFactory) {
        super(dataBufferFactory);
    }

    @Override
    protected final Mono<Void> writeWithInternal(Publisher<DataBuffer> body) {
        return this.writeAndFlushWithInternal((Publisher<Publisher<DataBuffer>>)Mono.just(body));
    }

    @Override
    protected final Mono<Void> writeAndFlushWithInternal(Publisher<Publisher<DataBuffer>> body) {
        if (this.writeCalled.compareAndSet(false, true)) {
            Processor<Publisher<DataBuffer>, Void> bodyProcessor = this.createBodyFlushProcessor();
            return Mono.from(subscriber -> {
                body.subscribe((Subscriber)bodyProcessor);
                bodyProcessor.subscribe(subscriber);
            });
        }
        return Mono.error((Throwable)new IllegalStateException("writeWith() or writeAndFlushWith() has already been called"));
    }

    protected abstract Processor<Publisher<DataBuffer>, Void> createBodyFlushProcessor();
}

