/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.server.reactive;

import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.springframework.core.io.buffer.DataBuffer;
import reactor.core.publisher.Operators;

abstract class AbstractRequestBodyPublisher
implements Publisher<DataBuffer> {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final AtomicReference<State> state = new AtomicReference<State>(State.UNSUBSCRIBED);
    private final AtomicLong demand = new AtomicLong();
    private Subscriber<? super DataBuffer> subscriber;

    AbstractRequestBodyPublisher() {
    }

    public void subscribe(Subscriber<? super DataBuffer> subscriber) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)(this.state + " subscribe: " + subscriber));
        }
        this.state.get().subscribe(this, subscriber);
    }

    protected final void onDataAvailable() {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)(this.state + " onDataAvailable"));
        }
        this.state.get().onDataAvailable(this);
    }

    protected final void onAllDataRead() {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)(this.state + " onAllDataRead"));
        }
        this.state.get().onAllDataRead(this);
    }

    protected final void onError(Throwable t) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error((Object)(this.state + " onError: " + t), t);
        }
        this.state.get().onError(this, t);
    }

    private boolean readAndPublish() throws IOException {
        while (this.hasDemand()) {
            DataBuffer dataBuffer = this.read();
            if (dataBuffer != null) {
                AbstractRequestBodyPublisher.getAndSub(this.demand, 1L);
                this.subscriber.onNext((Object)dataBuffer);
                continue;
            }
            return true;
        }
        return false;
    }

    private static long getAndSub(AtomicLong sequence, long toSub) {
        long u;
        long r;
        do {
            if ((r = sequence.get()) != 0L && r != Long.MAX_VALUE) continue;
            return r;
        } while (!sequence.compareAndSet(r, u = Operators.subOrZero((long)r, (long)toSub)));
        return r;
    }

    protected abstract void checkOnDataAvailable();

    protected abstract DataBuffer read() throws IOException;

    private boolean hasDemand() {
        return this.demand.get() > 0L;
    }

    private boolean changeState(State oldState, State newState) {
        return this.state.compareAndSet(oldState, newState);
    }

    private static enum State {
        UNSUBSCRIBED{

            @Override
            void subscribe(AbstractRequestBodyPublisher publisher, Subscriber<? super DataBuffer> subscriber) {
                Objects.requireNonNull(subscriber);
                if (!publisher.changeState(this, 1.NO_DEMAND)) {
                    throw new IllegalStateException(this.toString());
                }
                RequestBodySubscription subscription = new RequestBodySubscription(publisher);
                publisher.subscriber = subscriber;
                subscriber.onSubscribe((Subscription)subscription);
            }
        }
        ,
        NO_DEMAND{

            @Override
            void request(AbstractRequestBodyPublisher publisher, long n) {
                if (Operators.checkRequest((long)n, (Subscriber)publisher.subscriber)) {
                    Operators.addAndGet((AtomicLong)publisher.demand, (long)n);
                    if (publisher.changeState(this, 2.DEMAND)) {
                        publisher.checkOnDataAvailable();
                    }
                }
            }
        }
        ,
        DEMAND{

            @Override
            void request(AbstractRequestBodyPublisher publisher, long n) {
                if (Operators.checkRequest((long)n, (Subscriber)publisher.subscriber)) {
                    Operators.addAndGet((AtomicLong)publisher.demand, (long)n);
                }
            }

            @Override
            void onDataAvailable(AbstractRequestBodyPublisher publisher) {
                if (publisher.changeState(this, 3.READING)) {
                    try {
                        boolean demandAvailable = publisher.readAndPublish();
                        if (demandAvailable) {
                            publisher.changeState(3.READING, 3.DEMAND);
                            publisher.checkOnDataAvailable();
                        } else {
                            publisher.changeState(3.READING, 3.NO_DEMAND);
                        }
                    }
                    catch (IOException ex) {
                        publisher.onError(ex);
                    }
                }
            }
        }
        ,
        READING{

            @Override
            void request(AbstractRequestBodyPublisher publisher, long n) {
                if (Operators.checkRequest((long)n, (Subscriber)publisher.subscriber)) {
                    Operators.addAndGet((AtomicLong)publisher.demand, (long)n);
                }
            }
        }
        ,
        COMPLETED{

            @Override
            void request(AbstractRequestBodyPublisher publisher, long n) {
            }

            @Override
            void cancel(AbstractRequestBodyPublisher publisher) {
            }

            @Override
            void onAllDataRead(AbstractRequestBodyPublisher publisher) {
            }

            @Override
            void onError(AbstractRequestBodyPublisher publisher, Throwable t) {
            }
        };


        void subscribe(AbstractRequestBodyPublisher publisher, Subscriber<? super DataBuffer> subscriber) {
            throw new IllegalStateException(this.toString());
        }

        void request(AbstractRequestBodyPublisher publisher, long n) {
            throw new IllegalStateException(this.toString());
        }

        void cancel(AbstractRequestBodyPublisher publisher) {
            publisher.changeState(this, State.COMPLETED);
        }

        void onDataAvailable(AbstractRequestBodyPublisher publisher) {
        }

        void onAllDataRead(AbstractRequestBodyPublisher publisher) {
            if (publisher.changeState(this, State.COMPLETED) && publisher.subscriber != null) {
                publisher.subscriber.onComplete();
            }
        }

        void onError(AbstractRequestBodyPublisher publisher, Throwable t) {
            if (publisher.changeState(this, State.COMPLETED) && publisher.subscriber != null) {
                publisher.subscriber.onError(t);
            }
        }
    }

    private static final class RequestBodySubscription
    implements Subscription {
        private final AbstractRequestBodyPublisher publisher;

        public RequestBodySubscription(AbstractRequestBodyPublisher publisher) {
            this.publisher = publisher;
        }

        public final void request(long n) {
            if (this.publisher.logger.isTraceEnabled()) {
                this.publisher.logger.trace((Object)((Object)((Object)this.state()) + " request: " + n));
            }
            this.state().request(this.publisher, n);
        }

        public final void cancel() {
            if (this.publisher.logger.isTraceEnabled()) {
                this.publisher.logger.trace((Object)((Object)((Object)this.state()) + " cancel"));
            }
            this.state().cancel(this.publisher);
        }

        private State state() {
            return (State)((Object)this.publisher.state.get());
        }
    }
}

