/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.server.reactive;

import io.netty.handler.codec.http.HttpResponseStatus;
import java.util.Map;
import java.util.function.Function;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.core.io.buffer.NettyDataBufferFactory;
import org.springframework.http.server.reactive.HttpHandler;
import org.springframework.http.server.reactive.HttpHandlerAdapterSupport;
import org.springframework.http.server.reactive.ReactorServerHttpRequest;
import org.springframework.http.server.reactive.ReactorServerHttpResponse;
import reactor.core.publisher.Mono;
import reactor.ipc.netty.http.HttpChannel;

public class ReactorHttpHandlerAdapter
extends HttpHandlerAdapterSupport
implements Function<HttpChannel, Mono<Void>> {
    public ReactorHttpHandlerAdapter(HttpHandler httpHandler) {
        super(httpHandler);
    }

    public ReactorHttpHandlerAdapter(Map<String, HttpHandler> handlerMap) {
        super(handlerMap);
    }

    @Override
    public Mono<Void> apply(HttpChannel channel) {
        NettyDataBufferFactory bufferFactory = new NettyDataBufferFactory(channel.delegate().alloc());
        ReactorServerHttpRequest request = new ReactorServerHttpRequest(channel, bufferFactory);
        ReactorServerHttpResponse response = new ReactorServerHttpResponse(channel, (DataBufferFactory)bufferFactory);
        return this.getHttpHandler().handle(request, response).otherwise(ex -> {
            this.logger.error((Object)"Could not complete request", ex);
            channel.status(HttpResponseStatus.INTERNAL_SERVER_ERROR);
            return Mono.empty();
        }).doOnSuccess(aVoid -> this.logger.debug((Object)"Successfully completed request"));
    }
}

