/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.server.reactive;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.Enumeration;
import java.util.Map;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.reactivestreams.Publisher;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.http.HttpCookie;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.server.reactive.AbstractRequestBodyPublisher;
import org.springframework.http.server.reactive.AbstractServerHttpRequest;
import org.springframework.util.Assert;
import org.springframework.util.LinkedCaseInsensitiveMap;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Flux;

public class ServletServerHttpRequest
extends AbstractServerHttpRequest {
    private final HttpServletRequest request;
    private final DataBufferFactory dataBufferFactory;
    private final int bufferSize;
    private final Object bodyPublisherMonitor = new Object();
    private volatile RequestBodyPublisher bodyPublisher;
    private final Object cookieLock = new Object();

    public ServletServerHttpRequest(HttpServletRequest request, DataBufferFactory bufferFactory, int bufferSize) {
        super(ServletServerHttpRequest.initUri(request), ServletServerHttpRequest.initHeaders(request));
        Assert.notNull((Object)bufferFactory, (String)"'bufferFactory' must not be null");
        Assert.isTrue((bufferSize > 0 ? 1 : 0) != 0, (String)"'bufferSize' must be higher than 0");
        this.request = request;
        this.dataBufferFactory = bufferFactory;
        this.bufferSize = bufferSize;
    }

    private static URI initUri(HttpServletRequest request) {
        Assert.notNull((Object)request, (String)"'request' must not be null");
        try {
            StringBuffer url = request.getRequestURL();
            String query = request.getQueryString();
            if (StringUtils.hasText((String)query)) {
                url.append('?').append(query);
            }
            return new URI(url.toString());
        }
        catch (URISyntaxException ex) {
            throw new IllegalStateException("Could not get URI: " + ex.getMessage(), ex);
        }
    }

    private static HttpHeaders initHeaders(HttpServletRequest request) {
        int contentLength;
        String encoding;
        String requestContentType;
        HttpHeaders headers = new HttpHeaders();
        Enumeration names = request.getHeaderNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            Enumeration values = request.getHeaders(name);
            while (values.hasMoreElements()) {
                headers.add(name, (String)values.nextElement());
            }
        }
        MediaType contentType = headers.getContentType();
        if (contentType == null && StringUtils.hasLength((String)(requestContentType = request.getContentType()))) {
            contentType = MediaType.parseMediaType(requestContentType);
            headers.setContentType(contentType);
        }
        if (contentType != null && contentType.getCharset() == null && StringUtils.hasLength((String)(encoding = request.getCharacterEncoding()))) {
            Charset charset = Charset.forName(encoding);
            LinkedCaseInsensitiveMap params = new LinkedCaseInsensitiveMap();
            params.putAll(contentType.getParameters());
            params.put("charset", charset.toString());
            headers.setContentType(new MediaType(contentType.getType(), contentType.getSubtype(), (Map<String, String>)params));
        }
        if (headers.getContentLength() == -1L && (contentLength = request.getContentLength()) != -1) {
            headers.setContentLength(contentLength);
        }
        return headers;
    }

    public HttpServletRequest getServletRequest() {
        return this.request;
    }

    @Override
    public HttpMethod getMethod() {
        return HttpMethod.valueOf(this.getServletRequest().getMethod());
    }

    @Override
    public String getContextPath() {
        return this.getServletRequest().getContextPath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected MultiValueMap<String, HttpCookie> initCookies() {
        LinkedMultiValueMap httpCookies = new LinkedMultiValueMap();
        Cookie[] cookieArray = this.cookieLock;
        synchronized (this.cookieLock) {
            Cookie[] cookies = this.request.getCookies();
            // ** MonitorExit[var3_2] (shouldn't be in output)
            if (cookies != null) {
                for (Cookie cookie : cookies) {
                    String name = cookie.getName();
                    HttpCookie httpCookie = new HttpCookie(name, cookie.getValue());
                    httpCookies.add((Object)name, (Object)httpCookie);
                }
            }
            return httpCookies;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Flux<DataBuffer> getBody() {
        try {
            RequestBodyPublisher bodyPublisher = this.bodyPublisher;
            if (bodyPublisher == null) {
                Object object = this.bodyPublisherMonitor;
                synchronized (object) {
                    bodyPublisher = this.bodyPublisher;
                    if (bodyPublisher == null) {
                        this.bodyPublisher = bodyPublisher = this.createBodyPublisher();
                    }
                }
            }
            return Flux.from((Publisher)bodyPublisher);
        }
        catch (IOException ex) {
            return Flux.error((Throwable)ex);
        }
    }

    void handleAsyncListenerError(Throwable ex) {
        if (this.bodyPublisher != null) {
            this.bodyPublisher.onError(ex);
        }
    }

    void handleAsyncListenerComplete() {
        if (this.bodyPublisher != null) {
            this.bodyPublisher.onAllDataRead();
        }
    }

    private RequestBodyPublisher createBodyPublisher() throws IOException {
        RequestBodyPublisher bodyPublisher = new RequestBodyPublisher(this.request.getInputStream(), this.dataBufferFactory, this.bufferSize);
        bodyPublisher.registerListener();
        return bodyPublisher;
    }

    private static class RequestBodyPublisher
    extends AbstractRequestBodyPublisher {
        private final RequestBodyReadListener readListener = new RequestBodyReadListener();
        private final ServletInputStream inputStream;
        private final DataBufferFactory dataBufferFactory;
        private final byte[] buffer;

        public RequestBodyPublisher(ServletInputStream inputStream, DataBufferFactory dataBufferFactory, int bufferSize) {
            this.inputStream = inputStream;
            this.dataBufferFactory = dataBufferFactory;
            this.buffer = new byte[bufferSize];
        }

        public void registerListener() throws IOException {
            this.inputStream.setReadListener((ReadListener)this.readListener);
        }

        @Override
        protected void checkOnDataAvailable() {
            if (!this.inputStream.isFinished() && this.inputStream.isReady()) {
                this.onDataAvailable();
            }
        }

        @Override
        protected DataBuffer read() throws IOException {
            if (this.inputStream.isReady()) {
                int read = this.inputStream.read(this.buffer);
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace((Object)("read:" + read));
                }
                if (read > 0) {
                    DataBuffer dataBuffer = this.dataBufferFactory.allocateBuffer(read);
                    dataBuffer.write(this.buffer, 0, read);
                    return dataBuffer;
                }
            }
            return null;
        }

        private class RequestBodyReadListener
        implements ReadListener {
            private RequestBodyReadListener() {
            }

            public void onDataAvailable() throws IOException {
                RequestBodyPublisher.this.onDataAvailable();
            }

            public void onAllDataRead() throws IOException {
                RequestBodyPublisher.this.onAllDataRead();
            }

            public void onError(Throwable throwable) {
                RequestBodyPublisher.this.onError(throwable);
            }
        }
    }
}

