/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.server.reactive;

import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.Cookie;
import io.undertow.server.handlers.CookieImpl;
import io.undertow.util.HttpString;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.reactivestreams.Processor;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseCookie;
import org.springframework.http.ZeroCopyHttpOutputMessage;
import org.springframework.http.server.reactive.AbstractListenerServerHttpResponse;
import org.springframework.http.server.reactive.AbstractResponseBodyFlushProcessor;
import org.springframework.http.server.reactive.AbstractResponseBodyProcessor;
import org.springframework.util.Assert;
import org.xnio.ChannelListener;
import org.xnio.channels.StreamSinkChannel;
import reactor.core.publisher.Mono;

public class UndertowServerHttpResponse
extends AbstractListenerServerHttpResponse
implements ZeroCopyHttpOutputMessage {
    private final HttpServerExchange exchange;
    private StreamSinkChannel responseChannel;

    public UndertowServerHttpResponse(HttpServerExchange exchange, DataBufferFactory bufferFactory) {
        super(bufferFactory);
        Assert.notNull((Object)exchange, (String)"'exchange' is required.");
        this.exchange = exchange;
    }

    public HttpServerExchange getUndertowExchange() {
        return this.exchange;
    }

    @Override
    protected void applyStatusCode() {
        HttpStatus statusCode = this.getStatusCode();
        if (statusCode != null) {
            this.getUndertowExchange().setStatusCode(statusCode.value());
        }
    }

    @Override
    public Mono<Void> writeWith(File file, long position, long count) {
        this.applyHeaders();
        this.applyCookies();
        try {
            StreamSinkChannel responseChannel = this.getUndertowExchange().getResponseChannel();
            FileChannel in = new FileInputStream(file).getChannel();
            long result = responseChannel.transferFrom(in, position, count);
            if (result < count) {
                return Mono.error((Throwable)new IOException("Could only write " + result + " out of " + count + " bytes"));
            }
            return Mono.empty();
        }
        catch (IOException ex) {
            return Mono.error((Throwable)ex);
        }
    }

    @Override
    protected void applyHeaders() {
        for (Map.Entry<String, List<String>> entry : this.getHeaders().entrySet()) {
            HttpString headerName = HttpString.tryFromString((String)entry.getKey());
            this.exchange.getResponseHeaders().addAll(headerName, (Collection)entry.getValue());
        }
    }

    @Override
    protected void applyCookies() {
        for (String name : this.getCookies().keySet()) {
            for (ResponseCookie httpCookie : (List)this.getCookies().get((Object)name)) {
                CookieImpl cookie = new CookieImpl(name, httpCookie.getValue());
                if (!httpCookie.getMaxAge().isNegative()) {
                    cookie.setMaxAge(Integer.valueOf((int)httpCookie.getMaxAge().getSeconds()));
                }
                httpCookie.getDomain().ifPresent(arg_0 -> ((Cookie)cookie).setDomain(arg_0));
                httpCookie.getPath().ifPresent(arg_0 -> ((Cookie)cookie).setPath(arg_0));
                cookie.setSecure(httpCookie.isSecure());
                cookie.setHttpOnly(httpCookie.isHttpOnly());
                this.exchange.getResponseCookies().putIfAbsent(name, cookie);
            }
        }
    }

    protected AbstractResponseBodyFlushProcessor createBodyFlushProcessor() {
        return new ResponseBodyFlushProcessor();
    }

    private ResponseBodyProcessor createBodyProcessor() {
        if (this.responseChannel == null) {
            this.responseChannel = this.exchange.getResponseChannel();
        }
        ResponseBodyProcessor bodyProcessor = new ResponseBodyProcessor(this.responseChannel);
        bodyProcessor.registerListener();
        return bodyProcessor;
    }

    private class ResponseBodyFlushProcessor
    extends AbstractResponseBodyFlushProcessor {
        private ResponseBodyFlushProcessor() {
        }

        @Override
        protected Processor<DataBuffer, Void> createBodyProcessor() {
            return UndertowServerHttpResponse.this.createBodyProcessor();
        }

        @Override
        protected void flush() throws IOException {
            if (UndertowServerHttpResponse.this.responseChannel != null) {
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace((Object)"flush");
                }
                UndertowServerHttpResponse.this.responseChannel.flush();
            }
        }
    }

    private static class ResponseBodyProcessor
    extends AbstractResponseBodyProcessor {
        private final ChannelListener<StreamSinkChannel> listener = new WriteListener();
        private final StreamSinkChannel responseChannel;
        private volatile ByteBuffer byteBuffer;

        public ResponseBodyProcessor(StreamSinkChannel responseChannel) {
            Assert.notNull((Object)responseChannel, (String)"'responseChannel' must not be null");
            this.responseChannel = responseChannel;
        }

        public void registerListener() {
            this.responseChannel.getWriteSetter().set(this.listener);
            this.responseChannel.resumeWrites();
        }

        @Override
        protected boolean write(DataBuffer dataBuffer) throws IOException {
            if (this.byteBuffer == null) {
                return false;
            }
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("write: " + dataBuffer));
            }
            int total = this.byteBuffer.remaining();
            int written = this.writeByteBuffer(this.byteBuffer);
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("written: " + written + " total: " + total));
            }
            return written == total;
        }

        private int writeByteBuffer(ByteBuffer byteBuffer) throws IOException {
            int written;
            int totalWritten = 0;
            do {
                written = this.responseChannel.write(byteBuffer);
                totalWritten += written;
            } while (byteBuffer.hasRemaining() && written > 0);
            return totalWritten;
        }

        @Override
        protected void receiveBuffer(DataBuffer dataBuffer) {
            super.receiveBuffer(dataBuffer);
            this.byteBuffer = dataBuffer.asByteBuffer();
        }

        @Override
        protected void releaseBuffer() {
            super.releaseBuffer();
            this.byteBuffer = null;
        }

        private class WriteListener
        implements ChannelListener<StreamSinkChannel> {
            private WriteListener() {
            }

            public void handleEvent(StreamSinkChannel channel) {
                ResponseBodyProcessor.this.onWritePossible();
            }
        }
    }
}

