/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.bind.support;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class WebExchangeDataBinder
extends WebDataBinder {
    public WebExchangeDataBinder(Object target) {
        super(target);
    }

    public WebExchangeDataBinder(Object target, String objectName) {
        super(target, objectName);
    }

    public Mono<Void> bind(ServerWebExchange exchange) {
        ServerHttpRequest request = exchange.getRequest();
        Mono queryParams = Mono.just(request.getQueryParams());
        Mono formParams = exchange.getFormData().defaultIfEmpty((Object)new LinkedMultiValueMap());
        return Mono.zip(this::mergeParams, (Mono[])new Mono[]{queryParams, formParams}).map(this::getParamsToBind).doOnNext(values -> values.putAll(this.getMultipartFiles(exchange))).doOnNext(values -> values.putAll(this.getExtraValuesToBind(exchange))).then(values -> {
            this.doBind(new MutablePropertyValues(values));
            return Mono.empty();
        });
    }

    private MultiValueMap<String, String> mergeParams(Object[] paramMaps) {
        LinkedMultiValueMap result = new LinkedMultiValueMap();
        Arrays.stream(paramMaps).forEach(arg_0 -> WebExchangeDataBinder.lambda$mergeParams$3((MultiValueMap)result, arg_0));
        return result;
    }

    private Map<String, Object> getParamsToBind(MultiValueMap<String, String> params) {
        TreeMap<String, Object> valuesToBind = new TreeMap<String, Object>();
        for (Map.Entry entry : params.entrySet()) {
            String name = (String)entry.getKey();
            List values = (List)entry.getValue();
            if (values == null || values.isEmpty()) continue;
            if (values.size() > 1) {
                valuesToBind.put(name, values);
                continue;
            }
            valuesToBind.put(name, values.get(0));
        }
        return valuesToBind;
    }

    protected Map<String, List<MultipartFile>> getMultipartFiles(ServerWebExchange exchange) {
        return Collections.emptyMap();
    }

    protected Map<String, ?> getExtraValuesToBind(ServerWebExchange exchange) {
        return Collections.emptyMap();
    }

    private static /* synthetic */ void lambda$mergeParams$3(MultiValueMap result, Object map) {
        result.putAll((Map)((MultiValueMap)map));
    }
}

