/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.client.reactive;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.client.reactive.ClientHttpResponse;
import org.springframework.http.codec.BodyExtractor;
import org.springframework.http.codec.BodyExtractors;
import org.springframework.http.codec.HttpMessageReader;
import org.springframework.web.client.reactive.ClientResponse;
import org.springframework.web.client.reactive.WebClientStrategies;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class DefaultClientResponse
implements ClientResponse {
    private final ClientHttpResponse response;
    private final ClientResponse.Headers headers;
    private final WebClientStrategies strategies;

    public DefaultClientResponse(ClientHttpResponse response, WebClientStrategies strategies) {
        this.response = response;
        this.strategies = strategies;
        this.headers = new DefaultHeaders();
    }

    @Override
    public HttpStatus statusCode() {
        return this.response.getStatusCode();
    }

    @Override
    public ClientResponse.Headers headers() {
        return this.headers;
    }

    @Override
    public <T> T body(BodyExtractor<T, ? super ClientHttpResponse> extractor) {
        return extractor.extract(this.response, new BodyExtractor.Context(){

            @Override
            public Supplier<Stream<HttpMessageReader<?>>> messageReaders() {
                return DefaultClientResponse.this.strategies.messageReaders();
            }
        });
    }

    @Override
    public <T> Mono<T> bodyToMono(Class<? extends T> elementClass) {
        return this.body(BodyExtractors.toMono(elementClass));
    }

    @Override
    public <T> Flux<T> bodyToFlux(Class<? extends T> elementClass) {
        return this.body(BodyExtractors.toFlux(elementClass));
    }

    private class DefaultHeaders
    implements ClientResponse.Headers {
        private DefaultHeaders() {
        }

        private HttpHeaders delegate() {
            return DefaultClientResponse.this.response.getHeaders();
        }

        @Override
        public OptionalLong contentLength() {
            return this.toOptionalLong(this.delegate().getContentLength());
        }

        @Override
        public Optional<MediaType> contentType() {
            return Optional.ofNullable(this.delegate().getContentType());
        }

        @Override
        public List<String> header(String headerName) {
            List<String> headerValues = this.delegate().get(headerName);
            return headerValues != null ? headerValues : Collections.emptyList();
        }

        @Override
        public HttpHeaders asHttpHeaders() {
            return HttpHeaders.readOnlyHttpHeaders(this.delegate());
        }

        private OptionalLong toOptionalLong(long value) {
            return value != -1L ? OptionalLong.of(value) : OptionalLong.empty();
        }
    }
}

