/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.client.reactive;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.springframework.context.ApplicationContext;
import org.springframework.core.codec.ByteArrayDecoder;
import org.springframework.core.codec.ByteArrayEncoder;
import org.springframework.core.codec.ByteBufferDecoder;
import org.springframework.core.codec.ByteBufferEncoder;
import org.springframework.core.codec.CharSequenceEncoder;
import org.springframework.core.codec.Decoder;
import org.springframework.core.codec.Encoder;
import org.springframework.core.codec.StringDecoder;
import org.springframework.http.codec.DecoderHttpMessageReader;
import org.springframework.http.codec.EncoderHttpMessageWriter;
import org.springframework.http.codec.HttpMessageReader;
import org.springframework.http.codec.HttpMessageWriter;
import org.springframework.http.codec.ResourceHttpMessageWriter;
import org.springframework.http.codec.json.Jackson2JsonDecoder;
import org.springframework.http.codec.json.Jackson2JsonEncoder;
import org.springframework.http.codec.xml.Jaxb2XmlDecoder;
import org.springframework.http.codec.xml.Jaxb2XmlEncoder;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.web.client.reactive.WebClientStrategies;

class DefaultWebClientStrategiesBuilder
implements WebClientStrategies.Builder {
    private static final boolean jackson2Present = ClassUtils.isPresent((String)"com.fasterxml.jackson.databind.ObjectMapper", (ClassLoader)DefaultWebClientStrategiesBuilder.class.getClassLoader()) && ClassUtils.isPresent((String)"com.fasterxml.jackson.core.JsonGenerator", (ClassLoader)DefaultWebClientStrategiesBuilder.class.getClassLoader());
    private static final boolean jaxb2Present = ClassUtils.isPresent((String)"javax.xml.bind.Binder", (ClassLoader)DefaultWebClientStrategiesBuilder.class.getClassLoader());
    private final List<HttpMessageReader<?>> messageReaders = new ArrayList();
    private final List<HttpMessageWriter<?>> messageWriters = new ArrayList();

    DefaultWebClientStrategiesBuilder() {
    }

    public void defaultConfiguration() {
        this.messageReader(new DecoderHttpMessageReader(new ByteArrayDecoder()));
        this.messageReader(new DecoderHttpMessageReader(new ByteBufferDecoder()));
        this.messageReader(new DecoderHttpMessageReader(new StringDecoder(false)));
        this.messageWriter(new EncoderHttpMessageWriter(new ByteArrayEncoder()));
        this.messageWriter(new EncoderHttpMessageWriter(new ByteBufferEncoder()));
        this.messageWriter(new EncoderHttpMessageWriter(new CharSequenceEncoder()));
        this.messageWriter(new ResourceHttpMessageWriter());
        if (jaxb2Present) {
            this.messageReader(new DecoderHttpMessageReader(new Jaxb2XmlDecoder()));
            this.messageWriter(new EncoderHttpMessageWriter(new Jaxb2XmlEncoder()));
        }
        if (jackson2Present) {
            this.messageReader(new DecoderHttpMessageReader<Object>(new Jackson2JsonDecoder()));
            this.messageWriter(new EncoderHttpMessageWriter<Object>(new Jackson2JsonEncoder()));
        }
    }

    public void applicationContext(ApplicationContext applicationContext) {
        applicationContext.getBeansOfType(HttpMessageReader.class).values().forEach(this::messageReader);
        applicationContext.getBeansOfType(HttpMessageWriter.class).values().forEach(this::messageWriter);
    }

    @Override
    public WebClientStrategies.Builder messageReader(HttpMessageReader<?> messageReader) {
        Assert.notNull(messageReader, (String)"'messageReader' must not be null");
        this.messageReaders.add(messageReader);
        return this;
    }

    @Override
    public WebClientStrategies.Builder decoder(Decoder<?> decoder) {
        Assert.notNull(decoder, (String)"'decoder' must not be null");
        return this.messageReader(new DecoderHttpMessageReader(decoder));
    }

    @Override
    public WebClientStrategies.Builder messageWriter(HttpMessageWriter<?> messageWriter) {
        Assert.notNull(messageWriter, (String)"'messageWriter' must not be null");
        this.messageWriters.add(messageWriter);
        return this;
    }

    @Override
    public WebClientStrategies.Builder encoder(Encoder<?> encoder) {
        Assert.notNull(encoder, (String)"'encoder' must not be null");
        return this.messageWriter(new EncoderHttpMessageWriter(encoder));
    }

    @Override
    public WebClientStrategies build() {
        return new DefaultWebClientStrategies(this.messageReaders, this.messageWriters);
    }

    private static class DefaultWebClientStrategies
    implements WebClientStrategies {
        private final List<HttpMessageReader<?>> messageReaders;
        private final List<HttpMessageWriter<?>> messageWriters;

        public DefaultWebClientStrategies(List<HttpMessageReader<?>> messageReaders, List<HttpMessageWriter<?>> messageWriters) {
            this.messageReaders = DefaultWebClientStrategies.unmodifiableCopy(messageReaders);
            this.messageWriters = DefaultWebClientStrategies.unmodifiableCopy(messageWriters);
        }

        private static <T> List<T> unmodifiableCopy(List<? extends T> list) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }

        @Override
        public Supplier<Stream<HttpMessageReader<?>>> messageReaders() {
            return this.messageReaders::stream;
        }

        @Override
        public Supplier<Stream<HttpMessageWriter<?>>> messageWriters() {
            return this.messageWriters::stream;
        }
    }
}

