/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.server.adapter;

import java.security.Principal;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.core.ResolvableType;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.InvalidMediaTypeException;
import org.springframework.http.MediaType;
import org.springframework.http.codec.FormHttpMessageReader;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.util.Assert;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebSession;
import org.springframework.web.server.session.WebSessionManager;
import reactor.core.publisher.Mono;

public class DefaultServerWebExchange
implements ServerWebExchange {
    private static final List<HttpMethod> SAFE_METHODS = Arrays.asList(HttpMethod.GET, HttpMethod.HEAD);
    private static final FormHttpMessageReader FORM_READER = new FormHttpMessageReader();
    private static final ResolvableType MULTIVALUE_TYPE = ResolvableType.forClassWithGenerics(MultiValueMap.class, (Class[])new Class[]{String.class, String.class});
    private final ServerHttpRequest request;
    private final ServerHttpResponse response;
    private final Map<String, Object> attributes = new ConcurrentHashMap<String, Object>();
    private final Mono<WebSession> sessionMono;
    private final Mono<MultiValueMap<String, String>> formDataMono;
    private volatile boolean notModified;

    public DefaultServerWebExchange(ServerHttpRequest request, ServerHttpResponse response, WebSessionManager sessionManager) {
        Assert.notNull((Object)request, (String)"'request' is required");
        Assert.notNull((Object)response, (String)"'response' is required");
        Assert.notNull((Object)response, (String)"'sessionManager' is required");
        Assert.notNull((Object)response, (String)"'formReader' is required");
        this.request = request;
        this.response = response;
        this.sessionMono = sessionManager.getSession(this).cache();
        this.formDataMono = DefaultServerWebExchange.initFormData(request);
    }

    private static Mono<MultiValueMap<String, String>> initFormData(ServerHttpRequest request) {
        try {
            MediaType contentType = request.getHeaders().getContentType();
            if (MediaType.APPLICATION_FORM_URLENCODED.isCompatibleWith(contentType)) {
                return FORM_READER.readMono(MULTIVALUE_TYPE, request, Collections.emptyMap()).cache();
            }
        }
        catch (InvalidMediaTypeException invalidMediaTypeException) {
            // empty catch block
        }
        return Mono.empty();
    }

    @Override
    public ServerHttpRequest getRequest() {
        return this.request;
    }

    private HttpHeaders getRequestHeaders() {
        return this.getRequest().getHeaders();
    }

    @Override
    public ServerHttpResponse getResponse() {
        return this.response;
    }

    private HttpHeaders getResponseHeaders() {
        return this.getResponse().getHeaders();
    }

    @Override
    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    @Override
    public <T> Optional<T> getAttribute(String name) {
        return Optional.ofNullable(this.attributes.get(name));
    }

    @Override
    public Mono<WebSession> getSession() {
        return this.sessionMono;
    }

    @Override
    public <T extends Principal> Mono<T> getPrincipal() {
        return Mono.empty();
    }

    @Override
    public Mono<MultiValueMap<String, String>> getFormData() {
        return this.formDataMono;
    }

    @Override
    public boolean isNotModified() {
        return this.notModified;
    }

    @Override
    public boolean checkNotModified(Instant lastModified) {
        return this.checkNotModified(null, lastModified);
    }

    @Override
    public boolean checkNotModified(String etag) {
        return this.checkNotModified(etag, Instant.MIN);
    }

    @Override
    public boolean checkNotModified(String etag, Instant lastModified) {
        HttpStatus status = this.getResponse().getStatusCode();
        if (this.notModified || status != null && !HttpStatus.OK.equals((Object)status)) {
            return this.notModified;
        }
        if (this.validateIfUnmodifiedSince(lastModified)) {
            if (this.notModified) {
                this.getResponse().setStatusCode(HttpStatus.PRECONDITION_FAILED);
            }
            return this.notModified;
        }
        boolean validated = this.validateIfNoneMatch(etag);
        if (!validated) {
            this.validateIfModifiedSince(lastModified);
        }
        boolean isHttpGetOrHead = SAFE_METHODS.contains((Object)this.getRequest().getMethod());
        if (this.notModified) {
            this.getResponse().setStatusCode(isHttpGetOrHead ? HttpStatus.NOT_MODIFIED : HttpStatus.PRECONDITION_FAILED);
        }
        if (isHttpGetOrHead) {
            if (lastModified.isAfter(Instant.EPOCH) && this.getResponseHeaders().getLastModified() == -1L) {
                this.getResponseHeaders().setLastModified(lastModified.toEpochMilli());
            }
            if (StringUtils.hasLength((String)etag) && this.getResponseHeaders().getETag() == null) {
                this.getResponseHeaders().setETag(this.padEtagIfNecessary(etag));
            }
        }
        return this.notModified;
    }

    private boolean validateIfUnmodifiedSince(Instant lastModified) {
        if (lastModified.isBefore(Instant.EPOCH)) {
            return false;
        }
        long ifUnmodifiedSince = this.getRequestHeaders().getIfUnmodifiedSince();
        if (ifUnmodifiedSince == -1L) {
            return false;
        }
        Instant sinceInstant = Instant.ofEpochMilli(ifUnmodifiedSince);
        this.notModified = sinceInstant.isBefore(lastModified.truncatedTo(ChronoUnit.SECONDS));
        return true;
    }

    private boolean validateIfNoneMatch(String etag) {
        List<String> ifNoneMatch;
        if (!StringUtils.hasLength((String)etag)) {
            return false;
        }
        try {
            ifNoneMatch = this.getRequestHeaders().getIfNoneMatch();
        }
        catch (IllegalArgumentException ex) {
            return false;
        }
        if (ifNoneMatch.isEmpty()) {
            return false;
        }
        etag = this.padEtagIfNecessary(etag);
        for (String clientETag : ifNoneMatch) {
            if (!StringUtils.hasLength((String)clientETag) || !clientETag.replaceFirst("^W/", "").equals(etag.replaceFirst("^W/", ""))) continue;
            this.notModified = true;
            break;
        }
        return true;
    }

    private String padEtagIfNecessary(String etag) {
        if (!StringUtils.hasLength((String)etag)) {
            return etag;
        }
        if ((etag.startsWith("\"") || etag.startsWith("W/\"")) && etag.endsWith("\"")) {
            return etag;
        }
        return "\"" + etag + "\"";
    }

    private boolean validateIfModifiedSince(Instant lastModified) {
        if (lastModified.isBefore(Instant.EPOCH)) {
            return false;
        }
        long ifModifiedSince = this.getRequestHeaders().getIfModifiedSince();
        if (ifModifiedSince == -1L) {
            return false;
        }
        this.notModified = ChronoUnit.SECONDS.between(lastModified, Instant.ofEpochMilli(ifModifiedSince)) >= 0L;
        return true;
    }
}

