/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.server.handler;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import org.springframework.web.server.WebHandler;
import org.springframework.web.server.handler.WebHandlerDecorator;
import reactor.core.publisher.Mono;

public class FilteringWebHandler
extends WebHandlerDecorator {
    private final List<WebFilter> filters;

    public FilteringWebHandler(WebHandler targetHandler, WebFilter ... filters) {
        super(targetHandler);
        this.filters = FilteringWebHandler.initList(filters);
    }

    private static List<WebFilter> initList(WebFilter[] list) {
        return list != null ? Collections.unmodifiableList(Arrays.asList(list)) : Collections.emptyList();
    }

    public List<WebFilter> getFilters() {
        return this.filters;
    }

    @Override
    public Mono<Void> handle(ServerWebExchange exchange) {
        return new DefaultWebFilterChain().filter(exchange);
    }

    private class DefaultWebFilterChain
    implements WebFilterChain {
        private int index;

        private DefaultWebFilterChain() {
        }

        @Override
        public Mono<Void> filter(ServerWebExchange exchange) {
            if (this.index < FilteringWebHandler.this.filters.size()) {
                WebFilter filter = (WebFilter)FilteringWebHandler.this.filters.get(this.index++);
                return filter.filter(exchange, this);
            }
            return FilteringWebHandler.this.getDelegate().handle(exchange);
        }
    }
}

