/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.codec;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.reactivestreams.Publisher;
import org.springframework.core.ResolvableType;
import org.springframework.http.MediaType;
import org.springframework.http.ReactiveHttpOutputMessage;
import org.springframework.http.codec.HttpMessageWriter;
import org.springframework.http.codec.ServerHttpMessageWriter;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import reactor.core.publisher.Mono;

public abstract class AbstractServerHttpMessageWriter<T>
implements ServerHttpMessageWriter<T> {
    private HttpMessageWriter<T> writer;

    public AbstractServerHttpMessageWriter(HttpMessageWriter<T> writer) {
        this.writer = writer;
    }

    @Override
    public boolean canWrite(ResolvableType elementType, MediaType mediaType) {
        return this.writer.canWrite(elementType, mediaType);
    }

    @Override
    public List<MediaType> getWritableMediaTypes() {
        return this.writer.getWritableMediaTypes();
    }

    @Override
    public Mono<Void> write(Publisher<? extends T> inputStream, ResolvableType elementType, MediaType mediaType, ReactiveHttpOutputMessage outputMessage, Map<String, Object> hints) {
        return this.writer.write(inputStream, elementType, mediaType, outputMessage, hints);
    }

    @Override
    public Mono<Void> write(Publisher<? extends T> inputStream, ResolvableType streamType, ResolvableType elementType, MediaType mediaType, ServerHttpRequest request, ServerHttpResponse response, Map<String, Object> hints) {
        HashMap<String, Object> mergedHints = new HashMap<String, Object>(hints);
        mergedHints.putAll(this.resolveWriteHints(streamType, elementType, mediaType, request));
        return this.writer instanceof ServerHttpMessageWriter ? ((ServerHttpMessageWriter)this.writer).write(inputStream, streamType, elementType, mediaType, request, response, mergedHints) : this.writer.write(inputStream, elementType, mediaType, response, mergedHints);
    }

    protected abstract Map<String, Object> resolveWriteHints(ResolvableType var1, ResolvableType var2, MediaType var3, ServerHttpRequest var4);
}

