/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.cors.reactive;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.util.Assert;
import org.springframework.util.PathMatcher;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.reactive.CorsConfigurationSource;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.support.HttpRequestPathHelper;
import org.springframework.web.util.ParsingPathMatcher;

public class UrlBasedCorsConfigurationSource
implements CorsConfigurationSource {
    private final Map<String, CorsConfiguration> corsConfigurations = new LinkedHashMap<String, CorsConfiguration>();
    private PathMatcher pathMatcher = new ParsingPathMatcher();
    private HttpRequestPathHelper pathHelper = new HttpRequestPathHelper();

    public void setPathMatcher(PathMatcher pathMatcher) {
        Assert.notNull((Object)pathMatcher, (String)"PathMatcher must not be null");
        this.pathMatcher = pathMatcher;
    }

    public void setUrlDecode(boolean urlDecode) {
        this.pathHelper.setUrlDecode(urlDecode);
    }

    public void setHttpRequestPathHelper(HttpRequestPathHelper pathHelper) {
        Assert.notNull((Object)pathHelper, (String)"HttpRequestPathHelper must not be null");
        this.pathHelper = pathHelper;
    }

    public void setCorsConfigurations(Map<String, CorsConfiguration> corsConfigurations) {
        this.corsConfigurations.clear();
        if (corsConfigurations != null) {
            this.corsConfigurations.putAll(corsConfigurations);
        }
    }

    public Map<String, CorsConfiguration> getCorsConfigurations() {
        return Collections.unmodifiableMap(this.corsConfigurations);
    }

    public void registerCorsConfiguration(String path, CorsConfiguration config) {
        this.corsConfigurations.put(path, config);
    }

    @Override
    public CorsConfiguration getCorsConfiguration(ServerWebExchange exchange) {
        String lookupPath = this.pathHelper.getLookupPathForRequest(exchange);
        for (Map.Entry<String, CorsConfiguration> entry : this.corsConfigurations.entrySet()) {
            if (!this.pathMatcher.match(entry.getKey(), lookupPath)) continue;
            return entry.getValue();
        }
        return null;
    }
}

