/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.client;

import java.io.IOException;
import java.io.InputStream;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.springframework.http.HttpHeaders;
import org.springframework.http.client.AbstractClientHttpResponse;
import org.springframework.util.Assert;
import org.springframework.util.StreamUtils;

class OkHttp3ClientHttpResponse
extends AbstractClientHttpResponse {
    private final Response response;
    private HttpHeaders headers;

    public OkHttp3ClientHttpResponse(Response response) {
        Assert.notNull((Object)response, (String)"Response must not be null");
        this.response = response;
    }

    @Override
    public int getRawStatusCode() {
        return this.response.code();
    }

    @Override
    public String getStatusText() {
        return this.response.message();
    }

    @Override
    public InputStream getBody() throws IOException {
        ResponseBody body = this.response.body();
        return body != null ? body.byteStream() : StreamUtils.emptyInput();
    }

    @Override
    public HttpHeaders getHeaders() {
        if (this.headers == null) {
            HttpHeaders headers = new HttpHeaders();
            for (String headerName : this.response.headers().names()) {
                for (String headerValue : this.response.headers(headerName)) {
                    headers.add(headerName, headerValue);
                }
            }
            this.headers = headers;
        }
        return this.headers;
    }

    @Override
    public void close() {
        ResponseBody body = this.response.body();
        if (body != null) {
            body.close();
        }
    }
}

